/*
 * tocx.h --
 *
 *	Public header file used by the Tk ocx widget.
 *
 * Copyright (c) 1997 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */


#ifndef TOCX_H
#define TOCX_H

/*
 * MS Windows and OLE header files.
 */

#include <ole2.h>
#include <oleauto.h>

/*
 * Tk header files
 */

#ifndef _TK
extern "C" {
#include <tk.h>
}
#endif

/*
 * Function prototype for the OLE/Tcl type convertors.
 */

typedef int (*Tocx_StringToVariantProc) _ANSI_ARGS_((Tcl_Interp * interp,
			    char * string, struct TocxTypeInfo *tiPtr,
			    VARIANTARG * vargPtr));
typedef int (*Tocx_VariantToStringProc) _ANSI_ARGS_((Tcl_Interp * interp,
			    struct TocxTypeInfo *tiPtr, VARIANT *varPtr));


/*
 * Convenience macros for declaring OLE/Tcl type convertors.
 */

#define TOCX_TO_VAR_PROC(name) \
    EXTERN int		name _ANSI_ARGS_((Tcl_Interp * interp, \
			    char * string, TocxTypeInfo *tiPtr, \
			    VARIANTARG * vargPtr))
#define TOCX_TO_STR_PROC(name) \
    EXTERN int		name _ANSI_ARGS_((Tcl_Interp * interp, \
			    TocxTypeInfo *tiPtr, VARIANT * varPtr))

/*
 * This data structure representation a translation from a OLE enum string
 * name to a OLE constant value.
 */

typedef struct TocxEnum {
    char * name;
    VARIANT value;
} TocxEnum;

/*
 * This data structure stores type information of an OLE type, including
 * information about how to translate between OLE type and Tcl strings.
 */

typedef struct TocxTypeInfo {
    struct TocxTypeInfo * 	/* Points to the next link in a list */
        next;
    TYPEDESC * tdesc;		/* TYPEDESC of this type. */
    VARTYPE rootvt;		/* The "root" type of a type. E.g.
				 * root(**int) is int */
    Tocx_StringToVariantProc	/* Procedure to convert a string to */
        toVarProc;		/* this type. May be NULL. */
    Tocx_VariantToStringProc	/* Procedure to convert this type to */
        toStrProc;		/* a string. May be NULL. */
    char * name;		/* Name of property. May be NULL. */
    int pointerCount;		/* The Number of indirections (***int)=3. */
    int numEnums;		/* Number of enumerations. */
    TocxEnum * enums;		/* The enumerations. Used only if this
				 * is an enumeration type. */
} TocxTypeInfo;

/*
 * C functions exported by Tocx ("C" linkage).
 */

extern "C" __declspec( dllexport ) int Tocx_Init _ANSI_ARGS_((
	Tcl_Interp *interp));
extern "C" __declspec( dllexport ) int Tocx_SafeInit _ANSI_ARGS_((
	Tcl_Interp *interp));


#define EXPORT

EXTERN char *		Tocx_ElemDescName _ANSI_ARGS_((
			    ELEMDESC * edescPtr));
EXTERN char *		Tocx_ErrorCode _ANSI_ARGS_((HRESULT hr));
EXTERN int 		Tocx_InfoCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp * interp, int argc, char **argv));
EXTERN int		Tocx_StringToVariant _ANSI_ARGS_((Tcl_Interp * interp,
			    char * string, TocxTypeInfo *tiPtr,
			    VARIANTARG * vargPtr));
EXTERN int 		Tocx_TocxCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp * interp, int argc, char **argv));
EXTERN char *		Tocx_TypeName _ANSI_ARGS_((
			    TocxTypeInfo *tiPtr));
EXTERN int		Tocx_VariantToString _ANSI_ARGS_((Tcl_Interp * interp,
			    TocxTypeInfo *tiPtr, VARIANT * varPtr));
EXTERN char *		Tocx_VTName _ANSI_ARGS_((VARTYPE vt));


/*
 * Type convertors defined in Tocx.
 */

TOCX_TO_VAR_PROC(Tocx_StringToVariant_Color);
TOCX_TO_STR_PROC(Tocx_VariantToString_Color);
TOCX_TO_VAR_PROC(Tocx_StringToVariant_Enum);
TOCX_TO_STR_PROC(Tocx_VariantToString_Enum);

#endif /* TOCX_H */
