package require tocx 
wm geometry . 200x200

button .b -text "Click on the face"
pack .b

tocx .smi SMILE.SmileCtrl.1
pack .smi -expand yes -fill both
.smi bind Outside ".b config -text Outside-(?,?)"
.smi bind Inside  "inside"

proc inside {x y} {
    .b config -text Inside-($x,$y)
}

button .sad -text Sad   -command ".smi config Sad 1"
button .hap -text Happy -command ".smi config Sad 0"

pack .sad .hap -side left -anchor c











#
# Some commands to type on-line to display the options of the OCX'es.
#

# Print out the configuration options (full format)
#
#
proc pconf0 {w} {
    foreach item [lsort [$w configure]] {
	puts [format "%-20s\t%-20s\t%-15s\t%-5s\t%80s" \
	    [list [lindex $item 0]] \
	    [list [lindex $item 1]] \
	    [list [lindex $item 2]] \
	    [list [lindex $item 3]] \
	    [list [lindex $item 4]]]
    }
}

# Print out the configuration options (short format)
#
proc pconf {w} {
    set max0 1
    set max2 1
    set list [lsort [$w configure]]
    foreach item $list {
	set len [string len [lindex $item 0]]
	if {$max0 < $len} {
	    set max0 $len
	}
	set len [string len [lindex $item 2]]
	if {$max2 < $len} {
	    set max2 $len
	}
    }
    foreach item $list {
	puts [format "(%-[set max2]s) %-[set max0]s : %s" \
	    [lindex $item 2] \
	    [lindex $item 0] \
	    [lindex $item 4]]
    }
}

# Print out the methods
#
proc pmeth {w} {
    catch {$w foo__dd} d
    regsub "^wrong.*should be: " $d "" d
    regsub -all " or " $d "|" d
    regsub -all ", "   $d "|" d
    foreach o [lsort [split $d |]] {
	puts $o
    }
}


