package require tocx

wm geometry . 500x300

tocx .mov "AMOVIE.ActiveMovie Control.1"
#.mov config ShowDisplay 0 ShowControls 0
pack .mov -side left -expand yes -fill both

button .m1 -text "Clock movie" \
    -command ".mov config Filename clock.avi"
button .m2 -text "Drag&Drop movie" \
    -command ".mov config Filename dragdrop.avi"

button .play  -text Play  -command ".mov Run"
button .pause -text Pause -command ".mov Pause"
button .stop  -text Stop  -command ".mov Stop"

pack .m1 .m2 .play .pause .stop -side top -fill x

.m1 invoke







#
# Some commands to type on-line to display the options of the OCX'es.
#

# Print out the configuration options (full format)
#
#
proc pconf0 {w} {
    foreach item [lsort [$w configure]] {
	puts [format "%-20s\t%-20s\t%-15s\t%-5s\t%80s" \
	    [list [lindex $item 0]] \
	    [list [lindex $item 1]] \
	    [list [lindex $item 2]] \
	    [list [lindex $item 3]] \
	    [list [lindex $item 4]]]
    }
}

# Print out the configuration options (short format)
#
proc pconf {w} {
    set max0 1
    set max2 1
    set list [lsort [$w configure]]
    foreach item $list {
	set len [string len [lindex $item 0]]
	if {$max0 < $len} {
	    set max0 $len
	}
	set len [string len [lindex $item 2]]
	if {$max2 < $len} {
	    set max2 $len
	}
    }
    foreach item $list {
	puts [format "(%-[set max2]s) %-[set max0]s : %s" \
	    [lindex $item 2] \
	    [lindex $item 0] \
	    [lindex $item 4]]
    }
}

# Print out the methods
#
proc pmeth {w} {
    catch {$w foo__dd} d
    regsub "^wrong.*should be: " $d "" d
    regsub -all " or " $d "|" d
    regsub -all ", "   $d "|" d
    foreach o [lsort [split $d |]] {
	puts $o
    }
}

