/*
 * tkCanvas3dInt.h --
 *
 *	Declarations shared among all the files that implement
 *	canvas3d widgets.This file is included in all .c files of 
 *	canvas3d. 
 *
 *	This header has all the definitions for the different items 
 *	in canvas3d. It also declares all the functions implemented in
 *	the graphics engine. However, No functions are directly 
 *	dependent on any particular graphics engine.
 */

/* 
 * Please do not change the order of the header files. 
 */
#include "tkCanv3dConsts.h"
#include "geUtils.h" 

#ifndef _TK
#include "tk.h"
#endif

#include "tkCanvas3d.h"

#ifndef _TKCANVAS3DINT
#define _TKCANVAS3DINT

typedef struct SurfItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing surf. */
    SurfData *surfData;		/* Surface structure representative from 
				 * the graphics engine. */
    int itemCode;		/* ITEM_SURFACE */
    double ambientIntensity;	/* Ambient Intensity of the material. */
    double shininess;		/* Shininess of the material. */
    double transparency;	/* Transparency of the material. */
    canv3dColor diffuseColor;	/* Diffusive Color of the material. */
    canv3dColor emissiveColor;  /* Emissive Color of the material. */
    canv3dColor specularColor;	/* Specular Color of the material. */
    canv3dColor fillColor;	/* Fill Color of the material */
    int ramp;			
    char *textureString;	/* Name of the texture file. */
} SurfItem;

typedef struct MatrixItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing surf. */
    canv3dMatrix matrix;	/* Matrix to hold parsed values */
    MatrixData *matrixData;	/* Matrix structure representative from 
				 * the graphics engine. */
    int itemCode;		/* ITEM_MATRIX */
    int createFlag;		/* Indicates a new matrix to create*/
} MatrixItem;

typedef struct ViewItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing sphere. */
    int itemCode;		/* ITEM_VIEWPORT */
    SurfItem *background;	/* background surface of viewport. */
    MatrixItem *projMat;	/* Projection Matrix. */
    MatrixItem *worldMat;	/* World Matrix */
    MatrixItem *viewMat;	/* View Matrix */ 
    double halfHeight;		/* Half-Height of Viewing Frustum */
    double backPlanePos;	/* Position in z-coordinates of the 
				 * back clipping plane. */
    double frontPlanePos;	/* Position in z-coordinates of the 
				 * Front clipping plane. */
    double scaleX;		/* Window scaling factor in x-direction. */
    double scaleY;		/* Window scaling factor in y-direction. */
    double originX;		/* Window origin in x-direction. */
    double originY;		/* Window origin in y-direction. */
    canv3dCoord viewpoint;	/* Position of the camera. */
    canv3dDir normal;		/* View Normal direction for the camera. */
    canv3dDir up;		/* View Up Direction for the camera. */ 
} ViewItem;

typedef struct LightItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing surf. */
    LightData *lightData;	/* Light structure representative from 
				 * the graphics engine. */
    int itemCode;		/* ITEM_LIGHT */
    int lightType;		/* See light types in tkCanv3dConsts.h */
    canv3dColor color;		/* Color of the light. */
    canv3dDir position;		/* Position of light in world space. */
    canv3dDir direction;	/* Direction of light in world space. */
    double range;		/* Distance beyond which light has no effect.*/
    double fallOff;		/* Decrease in illumination between umbra,
				 * and outer edge of penumbra. */
    double attenuation0;	/* Constant light intensity. */
    double attenuation1;	/* Light intensity decreasing linearly. */
    double attenuation2;	/* Light intensity decreasing according
				 * to quadratic attenuation factor. */
    double thetaAngle;		/* Angle, in radians, of spotlight's umbra. */
    double phiAngle;		/* Angle, in radians, of the outeredge of 
				 * the spotlight's penumbra. */
} LightItem;

typedef struct BoxItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing sphere. */
    ShapeData *shapeData;	/* Shape structure representative from the 
				   graphics engine */
    int itemCode;		/* ITEM_BOX */
    double width;		/* Width of the box. */
    double height;		/* Height of the box. */
    double depth;		/* Depth of the box. */  
    canv3dCoord center;		/* Coordinate System Position that is 
				 * mapped to the center of the surf. */
    SurfItem *surface;		/* surface of the box. */
} BoxItem;

typedef struct ConeItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing sphere. */
    ShapeData *shapeData;	/* Shape structure representative from the 
				 * graphics engine */
    int itemCode;		/* ITEM_CONE */
    double radius;		/* Radius of the cone base. */
    double height;		/* Height of the cone */
    int numSections;		/* Number of sections that make up the 
				   surface of the cone. */
    canv3dCoord center;		/* Coordinate System Position that is 
				 * mapped to the center of the surf. */
    SurfItem *surface;		/* Surface of the cone. */
} ConeItem;

typedef struct CylinItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing sphere. */
    ShapeData *shapeData;	/* Shape structure representative from the 
				 * graphics engine */
    int itemCode;		/* ITEM_CYLINDER */
    double radius;		/* Radius of the Cylinder. */
    double height;		/* Height of the Cylinder. */
    int numSections;		/* Number of sections that make up 
				   the surface of the cylinder. */
    canv3dCoord center;		/* Coordinate System Position that is 
				 * mapped to the center of the surf. */
    SurfItem *surface;		/* Surface of the cylinder. */
} CylinItem;

typedef struct SphrItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing sphere. */
    ShapeData *shapeData;	/* Shape structure representative from the 
				 * graphics engine */
    int itemCode;		/* ITEM_SPHERE */
    double radius;		/* Radius of the sphere. */
    int numRings;		/* Number of full rings not including the 
				 * top and bottom caps.*/
    int numSections;		/* Number of sections each ring is divided into.
				 * Each section contains two triangles on full 
				 * rings and one on top and bottom caps. */
    canv3dCoord center;		/* Coordinate System Position that is 
				 * mapped to the center of the surf. */
    SurfItem *surface;		/* Surface of the sphere. */
} SphrItem;

typedef struct PolygonItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing plane. */
    ShapeData *shapeData;	/* Shape structure representative from the 
				 * graphics engine */
    int itemCode;		/* ITEM_PLANE */
    double radius;		/* Radius of the plane. */
    int edges;			/* Number of sections edges of the plane. */
    canv3dCoord center;		/* Coordinate System Position that is 
				 * mapped to the center of the surf. */
    SurfItem *surface;		/* Surface of the sphere. */
} PolygonItem;

typedef struct MeshItem  {
    Tk_Item3d header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas3d canvas3d;	/* Canvas3d containing plane. */
    ShapeData *shapeData;	/* Shape structure representative from the 
				 * graphics engine */
    int itemCode;		/* ITEM_MESH */
    canv3dCoord center;		/* Coordinate System Position that is 
				 * mapped to the center of the surf. */
    SurfItem *surface;		/* Surface of the mesh. */
    int expNumVert;		/* Expected number of vertices. */
    int availNumVert;		/* Available number of vertices. */
    int expNumFace;		/* Expected number of faces. */
    int availNumFace;		/* Available number of faces. */
} MeshItem;

/*
 * Definitions of graphics engine functions. All functions that have 
 * a return-type as 'int' return a boolean value, GE_OK or GE_ERROR, 
 * depending on the success of the task in the function.
 */

EXTERN void	GE_Init _ANSI_ARGS_((TkCanvas3d *canvas3dPtr));
EXTERN void	GE_ErrorString _ANSI_ARGS_((int id, char *error));

EXTERN void     GE_InitShape _ANSI_ARGS_((ShapeData *dataPtr));
EXTERN int	GE_CreateShapeExBuf _ANSI_ARGS_((geInterface *facePtr,
			    ShapeData *shapePtr, SurfData *surfPtr));
EXTERN int	GE_RenderShape _ANSI_ARGS_((geInterface face, ShapeData data));
EXTERN int	GE_FillShape _ANSI_ARGS_ ((ShapeData *dataPtr, int fillType));
EXTERN int	GE_WrapShape _ANSI_ARGS_ ((ShapeData *dataPtr, int wrapStyle));
EXTERN int	GE_TranslateShape _ANSI_ARGS_((ShapeData *dataPtr, 
			    double tx, double ty, double tz));
EXTERN int	GE_ScaleShape _ANSI_ARGS_((ShapeData *dataPtr, 
			    double sx, double sy, double sz));
EXTERN int	GE_RotateXShape _ANSI_ARGS_((ShapeData *dataPtr, double angle));
EXTERN int	GE_RotateYShape _ANSI_ARGS_((ShapeData *dataPtr, double angle));
EXTERN int	GE_RotateZShape _ANSI_ARGS_((ShapeData *dataPtr, double angle));
EXTERN int	GE_TransformShape _ANSI_ARGS_((ShapeData *dataPtr, 
			MatrixItem item));
EXTERN int	GE_DestroyShape _ANSI_ARGS_((ShapeData *dataPtr));

EXTERN int	GE_CreateBox _ANSI_ARGS_((BoxItem *itemPtr));
EXTERN int	GE_CreateCone _ANSI_ARGS_((ConeItem *itemPtr));
EXTERN int	GE_CreateCylinder _ANSI_ARGS_((CylinItem *itemPtr));
EXTERN int	GE_CreateSphere _ANSI_ARGS_((SphrItem *itemPtr));
EXTERN int	GE_CreatePolygon _ANSI_ARGS_((PolygonItem *itemPtr));
EXTERN int	GE_CreateMesh _ANSI_ARGS_((MeshItem *itemPtr));
EXTERN int	GE_AddVertex _ANSI_ARGS_((MeshItem *itemPtr, 
			    double x, double y, double z, int *vertexNum));
EXTERN int	GE_AddFace _ANSI_ARGS_((MeshItem *itemPtr, 
			    int v1, int v2, int v3, int *faceNum));
EXTERN int	GE_FaceEdgeEnable _ANSI_ARGS_((ShapeData *dataPtr, 
			    int faceNum, int enableType));

EXTERN int	GE_CreateSurf _ANSI_ARGS_((geInterface face, 
			    SurfItem *itemPtr));
EXTERN int	GE_CreateViewBackground _ANSI_ARGS_((geInterface face,
			    SurfItem *itemPtr));
EXTERN void	GE_DestroySurf _ANSI_ARGS_((SurfItem *itemPtr));

EXTERN int	GE_CreateMatrix _ANSI_ARGS_((geInterface face, 
			    MatrixItem *matrixPtr));
EXTERN void	GE_MatrixMultiply _ANSI_ARGS_(( MatrixItem *mat1, 
			    MatrixItem *mat2));
EXTERN void	GE_DestroyMatrix _ANSI_ARGS_((MatrixItem *matrixPtr));
EXTERN void	GE_IdentityMatrix _ANSI_ARGS_((geInterface face, 
			    MatrixItem *matrixPtr));
EXTERN void	GE_InverseMatrix _ANSI_ARGS_((geInterface face, 
			    MatrixItem *matrixPtr));
EXTERN void	GE_SetMatrixZY _ANSI_ARGS_((geInterface face,
			    canv3dDir vectorD, canv3dDir vectorU,
			    MatrixItem *matrixPtr));
EXTERN void	GE_TranslateMatrix _ANSI_ARGS_((geInterface face, 
			    double tx, double ty, double tz,
			    MatrixItem *matrixPtr));
EXTERN void	GE_ScaleMatrix _ANSI_ARGS_((geInterface face,
			    double sx, double sy, double sz,
			    MatrixItem *matrixPtr));
EXTERN void	GE_RotateXMatrix _ANSI_ARGS_((geInterface face,double angle, 
			    MatrixItem *matrixPtr));
EXTERN void	GE_RotateYMatrix _ANSI_ARGS_((geInterface face, double angle, 
			    MatrixItem *matrixPtr));
EXTERN void	GE_RotateZMatrix _ANSI_ARGS_((geInterface face, double angle, 
			    MatrixItem *matrixPtr));
 
EXTERN int	GE_CreateLight _ANSI_ARGS_((geInterface face, 
			    LightItem *itemPtr));
EXTERN void	GE_DestroyLight _ANSI_ARGS_((LightItem *itemPtr));

EXTERN int	GE_SetViewport _ANSI_ARGS_((geInterface *facePtr, 
			    int xOrigin, int yOrigin, int width, int height));
EXTERN void	GE_SetTransforms _ANSI_ARGS_((geInterface *facePtr,
			    MatrixItem *projPtr, MatrixItem *worldPtr,
			    MatrixItem *viewPtr));
EXTERN int	GE_RenderProjWorldView _ANSI_ARGS_((geInterface face, 
			    MatrixItem *projPtr, MatrixItem *worldPtr, 
			    MatrixItem *viewPtr));
EXTERN int	GE_SetCamera _ANSI_ARGS_((geInterface *facePtr,
			    ViewItem *viewPtr, canv3dCoord viewpoint,
			    canv3dDir normal, canv3dDir up));

EXTERN int	GE_ViewClears _ANSI_ARGS_((geInterface *facePtr, 
			    int clearsFlag));
EXTERN int	GE_RenderFill _ANSI_ARGS_((geInterface *facePtr, 
			    int fillType));
EXTERN int	GE_RenderShade _ANSI_ARGS_((geInterface *facePtr, 
			    int shadeType));
EXTERN int	GE_RenderFilter _ANSI_ARGS_((geInterface *facePtr, 
			    int filterType));
EXTERN int	GE_RenderZbuffer _ANSI_ARGS_((geInterface *facePtr, 
			    int zFlag));
EXTERN int	GE_RenderDither _ANSI_ARGS_((geInterface *facePtr, 
			    int ditherFlag));
EXTERN int	GE_RenderFog _ANSI_ARGS_((geInterface *facePtr, 
			    int fogFlag));
EXTERN int	GE_RenderAntiAlias _ANSI_ARGS_((geInterface *facePtr, 
			    int antiAliasFlag));
EXTERN int	GE_RenderPerspCor _ANSI_ARGS_((geInterface *facePtr, 
			    int perspCorFlag));

EXTERN int	GE_MakeProjMatrix _ANSI_ARGS_((geInterface face, 
			    double halfHeight, double backPlanePos,
			    double frontPlanePos, MatrixItem *matrixPtr));
EXTERN int	GE_MakeWorldMatrix _ANSI_ARGS_((geInterface face, 
			    double scaleX, double scaleY, 
			    double originX, double originY,
			    MatrixItem *matrixPtr));
EXTERN void	GE_MakeViewMatrix _ANSI_ARGS_((MatrixItem *projPtr, 
			    MatrixItem *worldPtr, MatrixItem *viewPtr));

/*
 * canvas3d-related procedures that are shared among Tk modules but not
 * exported to the outside world:
 */
EXTERN Tcl_Interp*	Tk_Canvas3dInterp _ANSI_ARGS_((Tk_Canvas3d canvas3d));
EXTERN geInterface*	Tk_Canvas3dFace _ANSI_ARGS_((Tk_Canvas3d canvas3d));
EXTERN void		Tk_CreateItem3dType _ANSI_ARGS_((Tk_Item3dType *typePtr));
EXTERN Tk_Item3dType *	Tk_GetItem3dTypes _ANSI_ARGS_((void));
EXTERN int		GE_UpdateClears _ANSI_ARGS_((Tk_Canvas3d canvas3dPtr));
EXTERN void		GE_DestroyAllItems(TkCanvas3d *canvas3dPtr);
EXTERN void		GE_ReCreateAllItems(Tcl_Interp *interp, TkCanvas3d *canvas3dPtr);


EXTERN int		GE_GetMemBitmap _ANSI_ARGS_((MemBitmap *mPtr));
/*
 * Parsing Utilities to get numeric constants equivalent from string values, 
 * as defined in tkCanvas3dConsts.h.
 */

EXTERN int	GE_GetConstAxis _ANSI_ARGS_((Tcl_Interp *interp, 
					    char *str, int *value));
EXTERN int	GE_GetConstBlend _ANSI_ARGS_((Tcl_Interp *interp, 
					     char *str, int *value));
EXTERN int	GE_GetConstBoolean _ANSI_ARGS_((Tcl_Interp *interp, 
					    char *str, int *value));
EXTERN int	GE_GetConstFill _ANSI_ARGS_((Tcl_Interp *interp, 
					    char *str, int *value));
EXTERN int	GE_GetConstFilter _ANSI_ARGS_((Tcl_Interp *interp, 
					    char *str, int *value));
EXTERN int	GE_GetConstItem _ANSI_ARGS_((Tcl_Interp *interp, 
					    char *str, int *value));
EXTERN int	GE_GetConstLight _ANSI_ARGS_((Tcl_Interp *interp, 
					     char *str, int *value));
EXTERN int	GE_GetConstShade _ANSI_ARGS_((Tcl_Interp *interp, 
					     char *str, int *value));
EXTERN int	GE_GetConstFaceEdge _ANSI_ARGS_((Tcl_Interp *interp, 
						char *str, int *value));
EXTERN int	GE_GetConstWrap _ANSI_ARGS_((Tcl_Interp *interp, 
						char *str, int *value));

#endif /* _TKCANVAS3DINT */
