/*
 * tkCanvas3d.h --
 *
 *	Declarations for Tk-related things that are visible
 *	outside of the Tk module itself.
 */

/*
 * The declarations in this header file are similar to the canvas3d related 
 * declarations in tk.h. This file is included only in tkCanvas3dInt.h.
 */

#include <tk.h>
#include <tkInt.h>
#include <tkPort.h>
#include <tkWinInt.h>
#include <tkWinPort.h>
#include <tkText.h>
#include <tkSelect.h>

#ifndef _TKCANVAS3D
#define _TKCANVAS3D


/*
 * Dummy type that is used by client.
 */

typedef struct Tk_Canvas3d_ *Tk_Canvas3d;

EXTERN int Canvas3d_Init _ANSI_ARGS_((Tcl_Interp *interp));


typedef struct Tk_Item3d  {
    int id;				/* Unique identifier for this item
					 * (also serves as first tag for
					 * item). */
    struct Tk_Item3d *nextPtr;		/* Next in display list of all
					 * items in this canvas3d.  Later items
					 * in list are drawn on top of earlier
					 * ones. */
    Tk_Uid staticTagSpace[TK_TAG_SPACE];/* Built-in space for limited # of
					 * tags. */
    Tk_Uid *tagPtr;			/* Pointer to array of tags.  Usually
					 * points to staticTagSpace, but
					 * may point to malloc-ed space if
					 * there are lots of tags. */
    int tagSpace;			/* Total amount of tag space available
					 * at tagPtr. */
    int numTags;			/* Number of tag slots actually used
					 * at *tagPtr. */
    struct Tk_Item3dType *typePtr;	/* Table of procedures that implement
					 * this type of item. */
    int x1, y1, x2, y2;			/* Bounding box for item, in integer
					 * canvas3d units. Set by item-specific
					 * code and guaranteed to contain every
					 * pixel drawn in item.  Item3d area
					 * includes x1 and y1 but not x2
					 * and y2. */
    int itemCode;			/* identifies the type of item */
} Tk_Item3d;


/*
 * Records of the following type are used to describe a type of
 * item (e.g.  boxes, surfaces, lights, etc.) that can form part of a
 * canvas3d widget.
 */

typedef int	Tk_Item3dCreateProc _ANSI_ARGS_((Tcl_Interp *interp,
		    Tk_Canvas3d canvas3d, Tk_Item3d *itemPtr, int argc,
		    char **argv));
typedef int	Tk_Item3dConfigureProc _ANSI_ARGS_((Tcl_Interp *interp,
		    Tk_Canvas3d canvas3d, Tk_Item3d *itemPtr, int argc,
		    char **argv, int flags));
typedef void	Tk_Item3dDeleteProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr));
typedef void	Tk_Item3dDisplayProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr));
typedef void	Tk_Item3dExBufProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr));
typedef void	Tk_Item3dRotateProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr, int axis, double angle));
typedef void	Tk_Item3dScaleProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr, double xScale, double yScale,
		    double zScale));
typedef void	Tk_Item3dTransformProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr, int matrixId));
typedef void	Tk_Item3dTranslateProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr, double xTrans, 
		    double yTrans, double zTrans));
typedef void	Tk_Item3dFillProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr, int fillType));
typedef void	Tk_Item3dWrapProc _ANSI_ARGS_((Tk_Canvas3d canvas3d,
		    Tk_Item3d *itemPtr, int wrapStyle));

typedef struct Tk_Item3dType {
    char *name;				/* The name of this type of item, such
					 * as "line". */
    int itemSize;			/* Total amount of space needed for
					 * item's record. */
    Tk_Item3dCreateProc *createProc;	/* Procedure to create a new item of
					 * this type. */
    Tk_ConfigSpec *configSpecs;		/* Pointer to array of configuration
					 * specs for this type.  Used for
					 * returning configuration info. */
    Tk_Item3dConfigureProc *configProc;	/* Procedure to call to change
					 * configuration options. */
    Tk_Item3dDeleteProc *deleteProc;	/* Procedure to delete existing item of
					 * this type. */
    Tk_Item3dDisplayProc *displayProc;	/* Procedure to display items of
					 * this type. */
    Tk_Item3dDisplayProc *exbufProc;	/* Procedure to create execute buffers
					 * for items of this type. */
    Tk_Item3dRotateProc *rotateProc;	/* Procedure to rotate items of 
					 *  this type. */
    Tk_Item3dScaleProc *scaleProc;	/* Procedure to rescale items of
					 * this type. */
    Tk_Item3dTransformProc *transformProc;/* Procedure to transform items of
					 * this type. */
    Tk_Item3dTranslateProc *translateProc;/* Procedure to translate items of
					 * this type. */
    Tk_Item3dFillProc *fillProc;	/* Procedure to fill items of 
					 *  this type. */
    Tk_Item3dWrapProc *wrapProc;	/* Procedure to wrap textures on 
					 * items of this type. */
    struct Tk_Item3dType *nextPtr;	/* Used to link types together into
					 * a list. */
} Tk_Item3dType;



/*
 * The record below describes a canvas3d widget.  It is made available
 * to the item procedures so they can access certain shared fields such
 * as the overall displacement and scale factor for the canvas3d.
 */

typedef struct TkCanvas3d {
    Tk_Window tkwin;		/* Window that embodies the canvas3d.  NULL
				 * means that the window has been destroyed
				 * but the data structures haven't yet been
				 * cleaned up.*/
    Display *display;		/* Display containing widget;  needed, among
				 * other things, to release resources after
				 * tkwin has already gone away. */
    Tcl_Interp *interp;		/* Interpreter associated with canvas3d. */
    Tcl_Command widgetCmd;	/* Token for canvas3d's widget command. */
    Tk_Item3d *firstItemPtr;	/* First in list of all items in canvas3d,
				 * or NULL if canvas3d empty. */
    Tk_Item3d *lastItemPtr;	/* Last in list of all items in canvas3d,
				 * or NULL if canvas3d empty. */

    /*
     *	Graphics Engine Representative in canvas3d.
     */
    geInterface *facePtr;

    /*
     * Rendering options. (might be useful to store and display values,
     * otherwise not required. so remove it.)
     */
    int fillType;		/* Point = 1, WireFrame = 2, Solid = 3 */ 
    int shadeType;              /* Flat = 1, Gouraud = 2, Phong = 3 */
    int filterType;		/* Texture Filter type */
    int zFlag;			/* Z enable on 1, disable on 0 */
    int ditherFlag;		/* Dither enable on 1, disable on 0 */
    int clearsFlag;		/* Clear enable on 1, disable on 0 */
    int fogFlag;		/* Fog enable on 1, disable on 0 */
    int antiAliasFlag;		/* Antialiasing enable on 1, disable on 0 */
    int perspCorFlag;		/* Perspective Correction
				 * enable on 1, disable on 0 */

    /*
     * Information used when displaying widget:
     */

    int borderWidth;		/* Width of 3-D border around window. */
    Tk_3DBorder bgBorder;	/* Used for canvas3d background. */
    int relief;			/* Indicates whether window as a whole is
				 * raised, sunken, or flat. */
    int highlightWidth;		/* Width in pixels of highlight to draw
				 * around widget when it has the focus.
				 * <= 0 means don't draw a highlight. */
    XColor *highlightBgColorPtr;
				/* Color for drawing traversal highlight
				 * area when highlight is off. */
    XColor *highlightColorPtr;	/* Color for drawing traversal highlight. */
    int inset;			/* Total width of all borders, including
				 * traversal highlight and 3-D border.
				 * Indicates how much interior stuff must
				 * be offset from outside edges to leave
				 * room for borders. */
    GC pixmapGC;		/* Used to copy bits from a pixmap to the
				 * screen and also to clear the pixmap. */
    int width, height;		/* Dimensions to request for canvas3d window,
				 * specified in pixels. */
    int redrawX1, redrawY1;	/* Upper left corner of area to redraw,
				 * in pixel coordinates.  Border pixels
				 * are included.  Only valid if
				 * REDRAW_PENDING flag is set. */
    int redrawX2, redrawY2;	/* Lower right corner of area to redraw,
				 * in integer canvas3d coordinates.  Border
				 * pixels will *not* be redrawn. */
    int confine;		/* Non-zero means constrain view to keep
				 * as much of canvas3d visible as possible. */

    /*
     * Transformation applied to canvas3d as a whole:  to compute screen
     * coordinates (X,Y) from canvas3d coordinates (x,y), do the following:
     *
     * X = x - xOrigin;
     * Y = y - yOrigin;
     */

    int xOrigin, yOrigin;	/* canvas3d coordinates corresponding to
				 * upper-left corner of window, given in
				 * canvas3d pixel units. */
    int drawableXOrigin, drawableYOrigin;
				/* During redisplay, these fields give the
				 * canvas3d coordinates corresponding to
				 * the upper-left corner of the drawable
				 * where items are actually being drawn
				 * (typically a pixmap smaller than the
				 * whole window). */

    /*
     * Information used for event bindings associated with items.
     */

    Tk_BindingTable bindingTable;
				/* Table of all bindings currently defined
				 * for this canvas3d.  NULL means that no
				 * bindings exist, so the table hasn't been
				 * created.  Each "object" used for this
				 * table is either a Tk_Uid for a tag or
				 * the address of an item named by id. */
    Tk_Item3d *currentItemPtr;	/* The item currently containing the mouse
				 * pointer, or NULL if none. */
    Tk_Item3d *newCurrentPtr;	/* The item that is about to become the
				 * current one, or NULL.  This field is
				 * used to detect deletions  of the new
				 * current item pointer that occur during
				 * Leave processing of the previous current
				 * item.  */
    double closeEnough;		/* The mouse is assumed to be inside an
				 * item if it is this close to it. */
    XEvent pickEvent;		/* The event upon which the current choice
				 * of currentItem is based.  Must be saved
				 * so that if the currentItem is deleted,
				 * can pick another. */
    int state;			/* Last known modifier state.  Used to
				 * defer picking a new current object
				 * while buttons are down. */

    
    /*
     * Information used for scanning:
     */

    int scanX;			/* X-position at which scan started (e.g.
				 * button was pressed here). */
    int scanXOrigin;		/* Value of xOrigin field when scan started. */
    int scanY;			/* Y-position at which scan started (e.g.
				 * button was pressed here). */
    int scanYOrigin;		/* Value of yOrigin field when scan started. */

    /*
     * Information used to speed up searches by remembering the last item
     * created or found with an item id search.
     */

    Tk_Item3d *hotPtr;		/* Pointer to "hot" item (one that's been
				 * recently used.  NULL means there's no
				 * hot item. */
    Tk_Item3d *hotPrevPtr;	/* Pointer to predecessor to hotPtr (NULL
				 * means item is first in list).  This is
				 * only a hint and may not really be hotPtr's
				 * predecessor. */

    /*
     * Miscellaneous information:
     */

    Tk_Cursor cursor;		/* Current cursor for window, or None. */
    char *takeFocus;		/* Value of -takefocus option;  not used in
				 * the C code, but used by keyboard traversal
				 * scripts.  Malloc'ed, but may be NULL. */
    double pixelsPerMM;		/* Scale factor between MM and pixels;
				 * used when converting coordinates. */
    int flags;			/* Various flags;  see below for
				 * definitions. */
    int nextId;			/* Number to use as id for next item
				 * created in widget. */
    struct TkPostscriptInfo *psInfoPtr;
				/* Pointer to information used for generating
				 * Postscript for the canvas3d.  NULL means
				 * no Postscript is currently being
				 * generated. */
} TkCanvas3d;

/*
 * Flag bits for canvas3des:
 *
 * REDRAW_PENDING -		1 means a DoWhenIdle handler has already
 *				been created to redraw some or all of the
 *				canvas3d.
 * REDRAW_BORDERS - 		1 means that the borders need to be redrawn
 *				during the next redisplay operation.
 * REPICK_NEEDED -		1 means DisplayCanvas should pick a new
 *				current item before redrawing the canvas3d.
 * GOT_FOCUS -			1 means the focus is currently in this
 *				widget, so should draw the insertion cursor
 *				and traversal highlight.
 * CURSOR_ON -			1 means the insertion cursor is in the "on"
 *				phase of its blink cycle.  0 means either
 *				we don't have the focus or the cursor is in
 *				the "off" phase of its cycle.
 * UPDATE_SCROLLBARS -		1 means the scrollbars should get updated
 *				as part of the next display operation.
 * LEFT_GRABBED_ITEM -		1 means that the mouse left the current
 *				item while a grab was in effect, so we
 *				didn't change canvas3dPtr->currentItemPtr.
 * REPICK_IN_PROGRESS -		1 means PickCurrentItem is currently
 *				executing.  If it should be called recursively,
 *				it should simply return immediately.
 *
 */

#define REDRAW_PENDING		1
#define REDRAW_BORDERS		2
#define REPICK_NEEDED		4
//#define GOT_FOCUS		8
#define CURSOR_ON		0x10
//#define UPDATE_SCROLLBARS	0x20
#define LEFT_GRABBED_ITEM	0x40
#define REPICK_IN_PROGRESS	0x100

/*
 *--------------------------------------------------------------
 *
 * Exported procedures and variables.
 *
 *--------------------------------------------------------------
 */

EXTERN void		Tk_Canvas3dEventuallyRedraw _ANSI_ARGS_((
			    Tk_Canvas3d canvas3d, int x1, int y1, int x2,
			    int y2));
EXTERN int		Tk_Canvas3dTagsParseProc _ANSI_ARGS_((
			    ClientData clientData, Tcl_Interp *interp,
			    Tk_Window tkwin, char *value, char *widgRec,
			    int offset));
EXTERN char *		Tk_Canvas3dTagsPrintProc _ANSI_ARGS_((
			    ClientData clientData, Tk_Window tkwin,
			    char *widgRec, int offset,
			    Tcl_FreeProc **freeProcPtr));
EXTERN Tk_Window	Tk_Canvas3dTkwin _ANSI_ARGS_((Tk_Canvas3d canvas3d));


/*
 * Tcl commands exported by Tk:
 */
EXTERN int		Tk_Canvas3dCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));

#endif /* _TKCANVAS3D */
