/* 
 * tkCanv3dConsts.h --
 * 
 *  This is a header file that defines all the constants used in Canvas3D.
 */

#ifndef _TKCANVAS3DCONSTS
#define _TKCANVAS3DCONSTS

#define GE_OK	    1
#define GE_ERROR    0

/*
 * Canvas3D Items.
 */
#define ITEM_VIEWPORT	1
#define ITEM_SURFACE	2
#define ITEM_MATRIX	3
#define ITEM_LIGHT	4
#define ITEM_COORDSYS	5

#define ITEM_BOX	10
#define ITEM_CONE	11
#define ITEM_CYLINDER	12
#define ITEM_SPHERE	13
#define ITEM_POLYGON	14
#define ITEM_MESH	15

/*
 * Texture Filtering Types.
 */
#define TEX_FILT_NEAREST	    1
#define TEX_FILT_LINEAR		    2
#define TEX_FILT_MIPNEAREST	    3
#define TEX_FILT_MIPLINEAR	    4
#define TEX_FILT_LINEARMIPNEAREST   5
#define TEX_FILT_LINEARMIPLINEAR    6

/*
 * Texture Blending Types.
 */
#define TEX_BLEND_DECAL		    1
#define TEX_BLEND_MODULATE	    2
#define TEX_BLEND_DECALALPHA	    3
#define TEX_BLEND_MODULATEALPHA	    4
#define TEX_BLEND_DECALMASK	    5
#define TEX_BLEND_MODULATEMASK	    6
#define TEX_BLEND_COPY		    7

/*
 * Shading Modes.
 */
#define SHADE_FLAT	1
#define SHADE_GOURAUD	2
#define SHADE_PHONG	3

/* 
 * Fill Types.
 */
#define FILL_POINT	1
#define FILL_WIREFRAME	2
#define FILL_SOLID	3

/*
 * Boolean Values.
 */
#define BOOL_ON	    1
#define BOOL_OFF    0

/*
 * Coordinate System Axis.
 */
#define AXIS_X	1			
#define AXIS_Y	2
#define AXIS_Z	3

/*
 * Light Source Types.
 */
#define LIGHT_POINT	    1		/* Light is a point source. */
#define LIGHT_SPOT	    2		/* Light is a spotlight source. */
#define LIGHT_DIRECTIONAL   3		/* Light is a directional source. */
#define LIGHT_PARALLEL	    4		/* Light is a parallel source. */
#define LIGHT_GLSPOT	    5		/* Light is a GL-style spotlight. */

/* 
 * Edge Visibility for a triangular face(made of say, vertices v1, 
 * v2 and v3) in the FILL_WIREFRAME mode. 
 */
#define FACE_EDGE1	1		/* v1v2 edge. */
#define FACE_EDGE2	2		/* v2v3 edge. */
#define FACE_EDGE3	3		/* v3v1 edge. */
#define FACE_EDGE12	4		/* v1v2 and v2v3 edges. */
#define FACE_EDGE23	5		/* v2v3 and v3v1 edges. */
#define FACE_EDGE31	6		/* v3v1 and v1v2 edges. */
#define FACE_EDGE123	7		/* All three edges. */

/* 
 * Wrap Styles for textures with direction vector v along z-axis and
 * up vector u along y-axis, with origin at [0 0 0]. 
 */
#define WRAP_FLAT	1		/* Flat wrapping style. */
#define WRAP_CYL_U	2		/* Cylindrical wrap in u-direction. */
#define WRAP_CYL_V	3		/* Cylindrical wrap in v-direction. */
#define WRAP_TORUS	4		/* Toroidal wrapping style. */

#endif /* _TKCANVAS3DCONSTS */