/*
 * tkCanv3dConsts.c -
 *
 *  This file has utility functions to support parsing of constant
 *  string values and represent them internally into integer form
 *  as defined in tkCanvas3dConsts.h. 
 *
 */

#include "tkCanvas3dInt.h"

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstAxis --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of axis.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.	
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int
GE_GetConstAxis(interp, str, value)
    Tcl_Interp *interp;		/* Interpreter for error reporting. */
    char *str;
    int *value;
{
    char c = str[0];
    
    if (strlen(str) != 1) {
	Tcl_AppendResult(interp, "wrong value for axis",
			" : must be a single character", 
			(char *) NULL);
	return TCL_ERROR;
    }
    if ( c == 'x' || c == 'X' ) {
	*value = AXIS_X;
    } else if ( c == 'y' || c == 'Y' ) {
	*value = AXIS_Y;
    } else if ( c == 'z' || c == 'Z' ) {
	*value = AXIS_Z;
    } else {
	Tcl_AppendResult(interp, "wrong value for axis",
	    " : must be x, y or z (or X, Y, or Z)",
			(char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstBlend --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of texture blend type.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstBlend(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "decal") == 0) {
	*value = TEX_BLEND_DECAL;
    } else if(strcmp(str, "modulate") == 0) {
	*value = TEX_BLEND_MODULATE;
    } else if(strcmp(str, "decal_alpha") == 0) {
	*value = TEX_BLEND_DECALALPHA;
    } else if(strcmp(str, "modulate_alpha") == 0) {
	*value = TEX_BLEND_MODULATEALPHA;
    } else if(strcmp(str, "decal_mask") == 0) {
	*value = TEX_BLEND_DECALMASK;
    } else if(strcmp(str, "modulate_mask") == 0) {
	*value = TEX_BLEND_MODULATEMASK;
    } else if(strcmp(str, "copy") == 0) {
	*value = TEX_BLEND_COPY;
    } else {
	Tcl_AppendResult(interp, "wrong value for BlendType",
	    " : must be decal, modulate, decal_alpha, modulate_alpha,",
	    "decal_mask, modulate_mask or copy",
			(char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstBoolean --
 *	
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of a boolean value.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int
GE_GetConstBoolean(interp, str, value)
    Tcl_Interp *interp;		/* Interpreter for error reporting. */
    char *str;
    int *value;
{
    if(strcmp(str, "on") == 0) {
	*value = BOOL_ON;
    } else if(strcmp(str, "off") == 0) {
	*value = BOOL_OFF;
    } else {
	Tcl_AppendResult(interp, "wrong value for onOrOff",
	    " : must be on or off", (char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
    
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstFill --
 *	
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of fill type for shapes.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstFill(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "point") == 0) {
	*value = FILL_POINT;
    } else if(strcmp(str, "wireframe") == 0) {
	*value = FILL_WIREFRAME;
    } else if(strcmp(str, "solid") == 0) {
	*value = FILL_SOLID;
    } else {
	Tcl_AppendResult(interp, "wrong value for fillType",
	    " : must be point, wireframe or solid",
			(char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstFilter --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of texture filtering types.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstFilter(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "nearest") == 0) {
	*value = TEX_FILT_NEAREST;
    } else if(strcmp(str, "linear") == 0) {
	*value = TEX_FILT_LINEAR;
    } else if(strcmp(str, "mip_nearest") == 0) {
	*value = TEX_FILT_MIPNEAREST;
    } else if(strcmp(str, "mip_linear") == 0) {
	*value = TEX_FILT_MIPLINEAR;
    } else if(strcmp(str, "linear_mip_nearest") == 0) {
	*value = TEX_FILT_LINEARMIPNEAREST;
    } else if(strcmp(str, "linear_mip_linear") == 0) {
	*value = TEX_FILT_LINEARMIPLINEAR;
    } else {
	Tcl_AppendResult(interp, "wrong value for FilterType",
	    " : must be nearest, linear, mip_nearest, mip_linear,",
	    "linear_mip_nearest or linear_mip_linear",
			(char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstItem --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of the item type.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstItem(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "viewport") == 0) {
	*value = ITEM_VIEWPORT;
    } else if(strcmp(str, "surface") == 0) {
	*value = ITEM_SURFACE;
    } else if(strcmp(str, "matrix") == 0) {
	*value = ITEM_MATRIX;
    } else if(strcmp(str, "light") == 0) {
	*value = ITEM_LIGHT;
    } else if(strcmp(str, "coordsys") == 0) {
	*value = ITEM_COORDSYS;
    } else if(strcmp(str, "box") == 0) {
	*value = ITEM_BOX;
    } else if(strcmp(str, "cone") == 0) {
	*value = ITEM_CONE;
    } else if(strcmp(str, "cylinder") == 0) {
	*value = ITEM_CYLINDER;
    } else if(strcmp(str, "sphere") == 0) {
	*value = ITEM_SPHERE;
    } else if(strcmp(str, "polygon") == 0) {
	*value = ITEM_POLYGON;
    } else if(strcmp(str, "mesh") == 0) {
	*value = ITEM_MESH;
    } else {
	Tcl_AppendResult(interp, "wrong value for an itemType",
	    " : must be viewport, surface, mattix, light, coordsys,",
	    "box, cone, cylinder, sphere or mesh",
			(char *) NULL);
	return TCL_ERROR;
    }


    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstLight --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of the light type.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstLight(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{   
    if(strcmp(str, "point") == 0) {
	*value = LIGHT_POINT;
    } else if(strcmp(str, "spot") == 0) {
	*value = LIGHT_SPOT;
    } else if(strcmp(str, "directional") == 0) {
	*value = LIGHT_DIRECTIONAL;
    } else if(strcmp(str, "parallel") == 0) {
	*value = LIGHT_PARALLEL;
    } else if(strcmp(str, "glspot") == 0) {
	*value = LIGHT_GLSPOT;
    } else {
	Tcl_AppendResult(interp, "wrong value for lightType",
	    " : must be point, spot, directional, parallel or glspot",
			(char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstShade --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of shade mode for the shapes.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstShade(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "flat") == 0) {
	*value = SHADE_FLAT;
    } else if(strcmp(str, "gouraud") == 0) {
	*value = SHADE_GOURAUD;
    } else if(strcmp(str, "phong") == 0) {
	*value = SHADE_PHONG;
    } else {
	Tcl_AppendResult(interp, "wrong value for shadeType",
	    " : must be flat, gouraud or phong",
			(char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * GE_GetConstFaceEdge --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of face enable types for triangular faces.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstFaceEdge(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "edge1") == 0) {
	*value = FACE_EDGE1;
    } else if(strcmp(str, "egde2") == 0) {
	*value = FACE_EDGE2;
    } else if(strcmp(str, "edge3") == 0) {
	*value = FACE_EDGE3;
    } else if(strcmp(str, "edge12") == 0) {
	*value = FACE_EDGE12;
    } else if(strcmp(str, "egde23") == 0) {
	*value = FACE_EDGE23;
    } else if(strcmp(str, "edge31") == 0) {
	*value = FACE_EDGE31;
    } else if(strcmp(str, "edge123") == 0) {
	*value = FACE_EDGE123;
    } else {
	Tcl_AppendResult(interp, "wrong value for edgeEnableType",
	    " : must be edge1, edge2, edge3, edge12, edge23, edge31,",
	    " or edge123", (char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * GE_GetConstWrap --
 *
 *	Get a constant value as defined in tkCanv3dConsts.h for
 *	the string value of wrap styles for the textures on shapes.
 *
 * Results:
 *	Returns TCL_ERROR if error occurs, else TCL_OK.		
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

int	
GE_GetConstWrap(interp, str, value)
    Tcl_Interp *interp;
    char *str;
    int *value;
{
    if(strcmp(str, "flat") == 0) {
	*value = WRAP_FLAT;
    } else if(strcmp(str, "cyl_u") == 0) {
	*value = WRAP_CYL_U;
    } else if(strcmp(str, "cyl_v") == 0) {
	*value = WRAP_CYL_V;
    } else if(strcmp(str, "torus") == 0) {
	*value = WRAP_TORUS;
    } else {
	Tcl_AppendResult(interp, "wrong value for wrapStyle",
	    " : must be flat, cyl_u, cyl_v or torus",
	    (char *) NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}
