/*
 * geUtils.h
 *
 *    This file has all the utility structures that are transported
 *    out of graphics engine library to the Tcl/Tk layer. 
 */

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <malloc.h>
#include <search.h>
#include "ddraw.h"
#include <d3d.h>

#include "d3dmacs.h"	
#include "d3dapp.h"
#include "d3dappi.h"
#include "d3dmath.h"

#ifndef _GEUTILS
#define _GEUTILS

#define PI 3.14159265359

#ifdef __cplusplus
extern "C" {
#endif
    typedef struct Defaultstag {
        D3DAppRenderState rs;
        BOOL bTexturesDisabled;
        BOOL bResizingDisabled;
        BOOL bClearsOn;
        char Name[30];
    } Defaults;
    void OverrideDefaults(Defaults* defaults);
#ifdef __cplusplus
};
#endif

typedef struct d3dmainglobals {
    HWND hWndMain;              /* application window handle */
    HINSTANCE hInstApp;         /* application instance for 
				 * dialog boxes */

    D3DAppRenderState rstate;   /* struct describing the 
                                   current render state */

    BOOL bSingleStepMode;        /* render one frame at a time */
    BOOL bDrawAFrame;            /* render on this pass of the main loop */
    BOOL bClearsOn;              /* clear the back and z-buffer each frame */
    BOOL bShowFrameRate;         /* show the frame rate at the top */
    BOOL bShowInfo;              /* show window information at the bottom */
    BOOL bResizingDisabled;      /* do not allow resizing */

    BOOL bResized;               /* the window has resized or some other 
				  * drastic change, the entire client area 
                                  * should be cleared */
    BOOL bQuit;                  /* program is about to terminate */
} d3dmainglobals;

typedef struct geInterface {
    D3DAppInfo* d3dapp;		/* Direct3D and DirectDraw objects. */
    d3dmainglobals myglobs;     /* Global values for the render state. */ 
    HWND msWinHandle;		/* Microsoft Window Handle */
    HINSTANCE msWinInstance;    /* Microsoft Window Instance */
} geInterface;

typedef struct canv3dColor {
    double r;		/* red value */
    double g;		/* green value */
    double b;		/* blue value */
    double a;		/* alpha value */
} canv3dColor;

typedef struct canv3dCoord {
    double x;		/* x position */
    double y;		/* y position */
    double z;           /* z position */
} canv3dCoord;

typedef struct canv3dDir {
    double x;		/* x direction */
    double y;		/* y direction */
    double z;		/* z direction */   
} canv3dDir;

typedef struct canv3dMatrix {
    double a1, a2, a3, a4;	/* Row 1, four elements */
    double b1, b2, b3, b4;	/* Row 2, four elements */
    double c1, c2, c3, c4;	/* Row 3, four elements */
    double d1, d2, d3, d4;      /* Row 4, four elements */
} canv3dMatrix;

typedef struct ShapeData{
    LPD3DVERTEX lpV;		/* object's vertices  */
    LPD3DTRIANGLE lpTri;        /* object's triangles */
    int num_vertices;		/* number of vertices */
    int num_faces;		/* number of faces */
    
    int fillType;		/* fill type of shape */
    int wrapU;			/* wrap style over u-axis */
    int wrapV;			/* wrap style over v-axis */

    D3DEXECUTEDATA d3dExData;	/* Execute data for the shape. */
    LPDIRECT3DEXECUTEBUFFER lpD3DExBuf; /* Execute Buffers for the shape */
} ShapeData;

typedef struct SurfData{
    D3DMATERIALHANDLE mat;		   /* material handles */
    LPDIRECT3DMATERIAL matObject;	   /* material object,
					      used to destroy! */
    D3DTEXTUREHANDLE tex;                  /* texture map handles  */
} SurfData;

typedef struct LightData{
    LPDIRECT3DLIGHT lightPtr;		   /* light handle */
} LightData;

typedef struct MatrixData{
    D3DMATRIX matData;			    /* matrix element values */
    D3DMATRIXHANDLE matrixPtr;		    /* matrix handle */
} MatrixData;

typedef struct MemBitmap {
    struct MemBitmap * next;	
    int type;		/* always 0 */
    char *name;		/* name of memory bitmap */
    int width;		/* width of bitmap */
    int height;		/* height of bitmap */
    int depth;		/* depth of bitmap */
    int *bits;		/* RGB, format according to depth. */
    LPDIRECTDRAWSURFACE lpSurface;  /* surface holding bitmap */
} MemBitmap;

#ifdef __cplusplus
extern "C" {
#endif 
extern char* D3DErrorToString(HRESULT error);
extern long FAR PASCAL WindowProc(HWND hWnd, UINT message, 
			    WPARAM wParam,
			    LPARAM lParam );
extern	    int		Direct3d_Init(geInterface *facePtr);
void __cdecl	Msg( LPSTR fmt, ... );
#ifdef __cplusplus
};
#endif

#endif

