#define ITERATIONS 500000

struct inst
{
  int opcode;
  int val;
};

extern int int_time();
extern int print_time(int, int, int);
extern void c_interpret(struct inst c_prg[]);
extern void c_interpret_opt(struct inst c_prg[]);

int c_mem[4] = {0, 1, 2, 3};
int c_stack[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int c_prg_size;
void init_c_mem();
void dump_c_mem();

extern struct inst c_prg[];
extern void c_interpret(struct inst c_prg[]);

void test_ms(int bench)
{
  int start_time;
  int end_time;
  int i;

  for(c_prg_size = 0 ; c_prg[c_prg_size].opcode != 99 ; c_prg_size++)
    ;
  
  /*
   *  normal
   */

  printf(" *** Microsoft cl **** \n");

  init_c_mem();				   /* initialize memory */
  dump_c_mem();				   /* verify memory contents */

  start_time = int_time();

  if (bench != 0)
    for( i = 0; i < ITERATIONS; i++)
      c_interpret(c_prg);	           /* execute cl-compiled function */
  c_interpret(c_prg);
  end_time = int_time();

  dump_c_mem();				   /* verify memory contents */

  if (bench != 0)
    print_time(start_time, end_time, 1);
  print_newline(); 

  /*
   *  optimized
   */
  printf(" *** Microsoft cl /02 **** \n");

  init_c_mem();				   /* initialize memory */
  dump_c_mem();				   /* verify memory contents */

  start_time = int_time();

  if (bench != 0)
    for( i = 0; i < ITERATIONS; i++)
      c_interpret_opt(c_prg);		   /* execute cl-compiled function */
  c_interpret_opt(c_prg);	          

  end_time = int_time();

  dump_c_mem();				   /* verify memory contents */

  if (bench != 0)
    print_time(start_time, end_time, 1);
  print_newline(); 

}

/* initialize memory */
void init_c_mem()
{
  c_mem[0]= 0;
  c_mem[1]= 1;
  c_mem[2]= 2;
  c_mem[3]= 3;
}

/* print out memory contents */
void dump_c_mem()
{
  int i;

  for(i = 0 ; i < /* MEM_SIZE */4 ; i++) {
    printf("Memory: %d ", c_mem[i]);
  }
  printf("\n");
}
