/* TEMPO Version X, 11/26/97, Copyright (c) IRISA/INRIA-Universite de Rennes */

struct inst {
  int opcode;
  int val;
};

extern int c_mem[];
extern int c_stack[];
extern int c_prg_size;

void c_interpret(struct inst prg [])
{
  int pc = 0;
  int sp = 0;
  
  for(0; pc < c_prg_size; pc = pc + 1)
    if (prg[pc].opcode == 0)	/* PUSH */
      {
	sp = sp + 1;
	c_stack[sp] = (prg[pc]).val;
      }
    else
      if (prg[pc].opcode == 1) /* POP */
	sp = sp - 1;
      else
	if (prg[pc].opcode == 2) /* ADD */
	  {
	    c_stack[sp - 1] = c_stack[sp] + c_stack[sp - 1];
	    sp = sp - 1;
	  } 
	else
	  if (prg[pc].opcode == 3) /* SUB */
	    {
	      c_stack[sp - 1] = c_stack[sp - 1] - c_stack[sp];
	      sp = sp - 1;
	    }
	  else
	    if (prg[pc].opcode == 4) /* MULT */
	      {
		c_stack[sp - 1] = c_stack[sp] * c_stack[sp - 1];
		sp = sp - 1;
	      }
	    else
	      if (prg[pc].opcode == 5) /* LD */
		c_stack[sp] = c_mem[c_stack[sp]];
	      else
		if (prg[pc].opcode == 6) /* ST */
		  {
		    c_mem[c_stack[sp]] = c_stack[sp - 1];
		    sp = sp - 2;
		  }
		else
		  {
		    printf( "\n Unrecognized instr: opcode-> %d  pc-> %d",
			    prg[pc].opcode, pc);
		  }
}
