(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew, Richard Samuels                     *)
(*     April 1999, all rights reserved.                               *)
(**********************************************************************)

(* annot.ml
 * Annotations for storing type information in object files. 
 *)

open Format;;
open Numtypes;;
open Identifier;;
open Tal;;
open Talpp;;


type c_inner = coercion list;;		(* Inner coercion, as in Prjr/Prjl *)
type c_outer = coercion list;;		(* Outer (explicit) coercion *)
type c_both = (c_outer * c_inner);;	(* Both, either can be [] *)

type genop_coercion = c_both;;		(* inner * outer. Either can be []. *)


(* An instruction can have any number of genop coercions. *)
type instr_coercion = genop_coercion list;;


type annotation = 
 | Instr_annot of int * instr_coercion	(* instr code * coercion *)
 | Coerce_annot of reg * coercion list
 | Malloc_annot of mallocarg * con option
 | Unpack_annot of identifier * reg * bool * genop_coercion
					(* bool is true if src reg = dst reg *)
 | Fallthru_annot of con list
 | Comment_annot of string
 | Label_annot of con option * coercion list(* Used for data & code labels *)
;;


val annotate_imp : Tal.tal_imp -> Buffer.t;;
