/* TAL Language Stuff
 *
 * Copyright Greg Morrisett, Neal Glew
 *   January 1999, all rights reserved
 *
 */

#include <stdio.h>
#include <stdlib.h>

/*** Memory Allocation ***/

extern void *GC_malloc(int size);
extern void *GC_malloc_atomic(int size);

void out_of_memory(void)
{
  fprintf(stderr, "\nout of memory!\n");
  exit(255);
}

/*** Array Support ***/

void array_bounds_error(void)
{
  fprintf(stderr, "\narray bounds error!\n");
  exit(255);
}

typedef struct {int size; void *elms[1];} *array;

array new_array(int size, void *init)
{
  array na=GC_malloc(4+size*4);
  na->size=size;
  if (init)
    while(size-->0)
      na->elms[size]=init;
  return na;
}

typedef void *(*gen_fun)(void *,int);

array new_array_f(int size, gen_fun f, void *env)
{
  int i;
  array na=GC_malloc(4+size*4);
  na->size=size;
  for(i=0; i<size; i++)
    na->elms[size]=(*f)(env,i);
  return na;
}

array new_array1(int size)
{
  array na=GC_malloc_atomic(4+size);
  na->size=size;
  return na;
}

array new_array2(int size)
{
  array na=GC_malloc_atomic(4+size*2);
  na->size=size;
  return na;
}

array new_array4(int size)
{
  array na=GC_malloc_atomic(4+size*4);
  na->size=size;
  return na;
}

array new_array8(int size)
{
  array na=GC_malloc_atomic(4+size*8);
  na->size=size;
  return na;
}

/*** Thread Local Area ***/

/* This defines the "thread-local area" for a single-threaded version of
 * TAL.  I've arbitrarily set this up to be about 80 words worth of data
 * so that we can have plenty of space to store things.
 */
int taltla[80];

/*** Cstring ***/

typedef char *Cstring;
typedef struct {int size; char chars[1];} *string;

string Cstring_to_string(Cstring s)
{
  string str;
  int size=(s?strlen(s):0);
  str=GC_malloc(4+size);
  str->size=size;
  while(size--) str->chars[size]=s[size];
  return str;
}

Cstring string_to_Cstring(string s)
{
  char *str=GC_malloc(s->size+1);
  int i;
  for(i=0; i<s->size; i++) str[i]=s->chars[i];
  str[s->size]='\0';
  return str;
}

/*** Program Entry ***/

extern void tal_main(void);
struct {int size; string strs[1];} *tal_args;

int main(int argc, char **argv)
{
  tal_args=GC_malloc(4+argc*4);
  tal_args->size=argc;
  while(argc--) tal_args->strs[argc]=Cstring_to_string(argv[argc]);
  tal_main();
  return 0;
}

/* EOF: tal_start.c */
