/* Popcorn Language Stuff
 *
 * Copyright Greg Morrisett, Neal Glew, Dan Grossman
 *   January 1999, all rights reserved
 *
 */

/* Now hacked by Dan for more informative debugging */

#include <stdlib.h>
#include <stdio.h>

extern void **tal_args;

typedef char *Cstring;
typedef struct {int size; char chars[1];} *string;
Cstring string_to_Cstring(string);
extern FILE* tal_stderr;

void** std_args()
{
 return tal_args;
}

static int callStackIndex   = -1;
static int callStackArrSize = 0;
static Cstring *callStack  = (Cstring *)0;

void callStackDump();

void callStackPush(string s) {
  int i;
  Cstring str = string_to_Cstring(s);
  if (callStackIndex == callStackArrSize-1) {
    if (callStackIndex == -1) {
      callStack        = (Cstring *)GC_malloc(4*sizeof(Cstring));
      callStackArrSize = 4;
    }
    else {
      Cstring *newstk = 
	(Cstring *)GC_malloc(callStackArrSize*2*sizeof(Cstring));
      for (i=0; i < callStackArrSize; ++i)
	newstk[i] = callStack[i];
      callStack = newstk;
      callStackArrSize *= 2;
    }
  }
  ++callStackIndex;
  callStack[callStackIndex] = str;
}

void callStackPop() { 
  --callStackIndex; 
}

int callStackSave() { /*notice we're not really saving*/
  return callStackIndex; 
} 
void callStackRestore(int i) { 
  callStackIndex = i; 
}

void callStackDump() {
  int i;
  fprintf(tal_stderr, "\nDumping stack information:\n");
  for(i=callStackIndex; i>=0; --i)
    fprintf(tal_stderr, "\t%s\n", callStack[i]);
}

void pop_never_null()
{
  fprintf(stderr, "Null pointer exception. \n\n");
  callStackDump();
  exit(255);
}

void pop_exn_handler(void* exn)
{
  /* We could actually do something here but for now.*/
 fprintf(stderr, "Uncaught exception: %p\n",exn);
 callStackDump();
 exit(255);
}

