(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew, Chris Hawblitzel, Dan Grossman,     *)
(*     Frederick Smith                                                *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* Soon we should probably stop using cl and friends entirely *)

open Talout;;
open Gcd;;

type code_gen = CgStack | CgReg

let code_gen       = ref CgStack
let preprocessonly = ref false
(* Cyclone *)
(* TEMPORARY; CYCLONE/MASM *)
let unsafemasm = ref false
(* End Cyclone *)

let compile_pop_file filename basename modname =
  try
    let libdir = 
      try Sys.getenv "POPCORNLIB"
      with Not_found -> 
	try Filename.concat 
	    (Sys.getenv "TALCLIB")
	    (Filename.concat ".." (Filename.concat "popcorn" "lib"))
	with Not_found -> Filename.current_dir_name in
    add_include libdir;

    let talfile    = basename ^ ".tal"    in
    let impfile    = modname  ^ "_i.tali" in 
    let expfile    = modname  ^ "_e.tali" in 
    let impfileabs = basename ^ "_i.tali" in 
    let expfileabs = basename ^ "_e.tali" in
    let objectfile = basename ^ object_file_suffix in
    (* by default cl pre-processes into a .i file *) 
    let preprocfile  = modname ^ ".i" in 
    let ppop_removed = ref false      in
    let rm_ppop () = 
      if not !ppop_removed then Sys.remove preprocfile; ppop_removed := true 
    in
    Printf.printf "Compiling file: %s\n" basename; flush stdout;
    
    Sys.command
      (if Sys.os_type = "Unix" 
      then 
	let inc_string = 
	  List.fold_left (fun r d -> "-I " ^d ^ " " ^ r) "" !includes in
	Printf.sprintf "gcc -x c -E %s %s > %s" inc_string filename preprocfile
      else 
	let inc_string = 
	  List.fold_left (fun r d -> "/I" ^d ^ " " ^ r) "" !includes in
	Printf.sprintf "cl /nologo %s /P /TC %s" inc_string filename); 
     (if !preprocessonly
     then true
     else
       (try
      	 let abort_on_error () = if Gcdfec.error_p () then raise Gcdfec.Exit in
      	 let decls = Gcdfe.fe Poplex.token Popparse.top preprocfile in
      	 abort_on_error ();
      	 let popmod = Poptype.type_check decls in
      	 abort_on_error ();
      	 let (implementation,imports,exports) =
	   match !code_gen with
	     CgStack ->
	       Popcompile.code_gen    modname impfile expfile popmod 
	   | CgReg ->
	       Printf.eprintf "%s: register allocator currently broken :-(\n"
	      	 basename; flush stderr; raise Gcdfec.Exit
(*          Popcompilereg.code_gen modname impfile expfile popmod*) 
      	 in
      	 rm_ppop ();
(* Cyclone *)
(* TEMPORARY; CYCLONE/MASM *)
      	 if !unsafemasm
      	 then Talout.write_options :=                  
	    { Talpp.style=Talpp.MASM;                  
              Talpp.kinds=false;                       
              Talpp.cons=false}                        
      	 else Talout.write_options := Talpp.std_options;
(* End Cyclone *)
      	 Talout.write_int (modname^"_i") impfileabs imports;
      	 Talout.write_int (modname^"_e") expfileabs exports;
      	 Talout.write_imp modname talfile implementation;
(* Cyclone *)
      	 if !unsafemasm & assemble_p() then
	   begin
             Talout.asm talfile (Some objectfile);
             add_object_file objectfile;
             true
	   end
      	 else if !unsafemasm then true
      	 else
(* End Cyclone *)
	   if assemble_p () then begin
	     (Talout.verify_and_asm talfile (Some objectfile)) &
	     (add_object_file objectfile; true)
	   end else
	     Talout.verify talfile
       with e -> rm_ppop (); raise e))
  with Gcdfec.Exit -> false
      
let middle () =
  add_object_file ("stdlib"^object_file_suffix);
  add_object_file ("pop_runtime"^object_file_suffix);
(* Cyclone *)
  add_object_file ("cyclonelib"^object_file_suffix);
(* End Cyclone *)
  true
;;

let do_link objfiles libraries executable =
  Talout.link objfiles executable
;;

let toolname = "popcorn";;
set_tooldesc "popcorn: A safe C subset compiler";;

let options =
  std_options @ 
  [(*"--no-opt",     Arg.Clear Popcompilereg.optimize, "don't optimize";
   "--no-regalloc",Arg.Clear Popcompilereg.allocateregs,
                                            "don't register allocate";*)
(* Cyclone *)
   (* TEMPORARY; CYCLONE/MASM *)
   "--unsafemasm", Arg.Set unsafemasm, "don't type check, truncate types";
(* End Cyclone *)
   "-E", Arg.Set preprocessonly, "only run pre-processor, creating .i file";
   "--debug", Arg.Set Poptype.debug,
    "generate slower code but easier to debug null pointers";
   "--stack-codegen", Arg.Unit (fun () -> code_gen := CgStack), 
    "use stack-based code generator";
   "--reg-codegen",   Arg.Unit (fun () -> code_gen := CgReg),
    "use register allocator"]
;;

let file_types = [".pop",compile_pop_file] @ std_file_types;;

let main () = driver toolname options file_types middle do_link;;

Printexc.catch main () ;;

(* EOF: popcorn.ml *)
