#ifndef BITVEC_H
#define BITVEC_H

#include "core.h"
#include "list.h"
#include "dict.h"
#include "set.h"

prefix Bitvec {
open   Bitvec {

extern bool get  (int bvec[], int pos);
extern void set  (int bvec[], int pos);
extern void clear(int bvec[], int pos);

extern void union_two    (int dest[], int src1[], int src2[]);
extern void intersect_two(int dest[], int src1[], int src2[]);
extern void diff_two     (int dest[], int src1[], int src2[]);
extern bool compare_two  (int src1[], int src2[]);

extern int  new_empty(int sz)    [];
extern int  new_full (int sz)    [];
extern int  new_copy (int old[]) [];
extern void clear_all(int old[]);
extern void set_all  (int old[]);

extern int from_list<a,b>(<a,b>Dict::dict d,int f(b),int sz, <a>List::list l)[];
extern <int>List::list to_sorted_list(int bvec[],int sz);

extern void print_bvec(int[]);

}}

#endif BITVEC_H
