/* Stack Operations */

#define PUSH 0
#define POP 1

/* Arithmetic instructions */

#define ADD 2
#define SUB 3
#define MUL 4

/* Memory instructions */

#define LD 5
#define ST 6

/* Control instructions */

#define JMP 7
#define JEQ 8
#define CMP 9

/* Empty operand */

#define EMPTY 98

/* End instruction */

#define END 99

/* Machine configuration */

#define MEM_SIZE 4
#define STACK_SIZE 30

/* Instruction type */

struct inst
{
  int opcode;
  int val;
};

struct inst c_prg[]=
{
  {PUSH, 60},
  {PUSH, 3},
  {LD, EMPTY},		    /* push mem[pop] (3) */
  {ADD, EMPTY},             /* 63 */

  {PUSH, 10},               /* 630 */
  {MUL, EMPTY},
  {PUSH, 0},
  {ST, EMPTY},              /* mem[0] = 630; */

  {PUSH, 10},               /* mem[1] = 10; */
  {PUSH, 1},
  {ST  ,  EMPTY},
  {PUSH, 20},               /* mem[2] = 20; */
  {PUSH, 2},
  {ST  ,  EMPTY},
  {PUSH, 3},               /* mem[3] =  3; */
  {PUSH, 3},
  {ST  ,  EMPTY},

  {END, EMPTY}
};
