(**********************************************************************)
(* (c) Neal Glew,                                                     *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* Numtypes - provides a number of machine numeric types and ops on them.
 *)

type int8;;
type int16;;
type int32;;

(* Constants *)

val i32_0 : int32;;
val i32_1 : int32;;
val i32_2 : int32;;
val i32_3 : int32;;
val i32_4 : int32;;
val i32_8 : int32;;
val i32_16 : int32;;
val i32_255 : int32;;

(* Conversions *)

val int_to_int32 : int -> int32;;
val int32_to_int : int32 -> int;;
val int32_of_string : string -> int32;;

val string_of_int8 : int8 -> string;;
val string_of_int16 : int16 -> string;;
val string_of_int32 : int32 -> string;;

val int16_to_int32 : int16 -> int32;;
val int32_to_int8 : int32 -> int8;;
val int32_to_int16 : int32 -> int16;;

val int8_to_byte : int8 -> char;;
val int32_to_1byte : int32 -> char;;
val int32_to_2bytes : int32 -> char*char;;
val int32_to_4bytes : int32 -> char*char*char*char;; (* lsb...msb *)

(* int32 ops *)

val (~-$) : int32 -> int32;;
val (+$) : int32 -> int32 -> int32;;
val (-$) : int32 -> int32 -> int32;;
val ( *$ ) : int32 -> int32 -> int32;;
val (/$) : int32 -> int32 -> int32;;
val mod32 : int32 -> int32 -> int32;;
val (=$) : int32 -> int32 -> bool;;
val (<>$) : int32 -> int32 -> bool;;
val (<$) : int32 -> int32 -> bool;;
val (<=$) : int32 -> int32 -> bool;;
val (>$) : int32 -> int32 -> bool;;
val (>=$) : int32 -> int32 -> bool;;
val lnot32 : int32 -> int32;;
val land32 : int32 -> int32 -> int32;;
val lor32 : int32 -> int32 -> int32;;
val lxor32 : int32 -> int32 -> int32;;
val lsl32 : int32 -> int32 -> int32;;
val lsr32 : int32 -> int32 -> int32;;
val asr32 : int32 -> int32 -> int32;;

(* EOF: numtypes.mli *)
