(**********************************************************************)
(* (c) Neal Glew,                                                     *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* Numtypes - provides a number of machine numeric types and ops on them.
 *)

type int8 = int;;
type int16 = int;;
type int32 = int;;

let i32_0 = 0;;
let i32_1 = 1;;
let i32_2 = 2;;
let i32_3 = 3;;
let i32_4 = 4;;
let i32_8 = 8;;
let i32_16 = 16;;
let i32_255 = 255;;

let int_to_int32 i = i;;
let int32_to_int i = i;;
let int32_of_string s = int_of_string s;;

let string_of_int8 i = string_of_int i;;
let string_of_int16 i = string_of_int i;;
let string_of_int32 i = string_of_int i;;

let int16_to_int32 i = i;;
let int32_to_int8 i = i;;
let int32_to_int16 i = i;;

let int8_to_byte i = Char.chr (i land 255);;
let int32_to_1byte i = Char.chr (i land 255);;
let int32_to_2bytes i = (Char.chr (i land 255),Char.chr ((i lsr 8) land 255));;
let int32_to_4bytes i =
  let b4 =
    if (i < 0) then
      ((i asr 24) land 0xFF) lor 0x80
    else
      (i lsr 24) land 0xFF in
  (Char.chr (i land 255),
   Char.chr ((i lsr 8) land 255),
   Char.chr ((i lsr 16) land 255),
   Char.chr b4)
;;

let (~-$) = (~-);;
let (+$) = (+);;
let (-$) = (-);;
let ( *$ ) = ( * );;
let (/$) = (/);;
let mod32 = (mod);;
let (=$) = (=);;
let (<>$) = (<>);;
let (<$) = (<);;
let (<=$) = (<=);;
let (>$) = (>);;
let (>=$) = (>=);;
let lnot32 i = lnot i;;
let land32 i1 i2 = i1 land i2;;
let lor32 i1 i2 = i1 lor i2;;
let lxor32 i1 i2 = i1 lxor i2;;
let lsl32 i1 i2 = i1 lsl i2;;
let lsr32 i1 i2 = i1 lsr i2;;
let asr32 i1 i2 = i1 asr i2;;

(* EOF: numtypes.ml *)
