(define revappend
  (lambda (x y)
    (if (null? x) y
	(revappend (cdr x) (cons (car x) y)))))

(define reverse (lambda (x) (revappend x '())))

(define generate
  (lambda (i l)
    (if (= i 0) l (generate (- i 1) (cons i l)))))

(define split
  (lambda (l1 l2 l3)
    (if (null? l1) (cons l2 l3)
	(split (cdr l1) l3 (cons (car l1) l2)))))

(define merge
  (lambda (l1 l2 l3)
    (cond ((null? l1) (revappend l2 l3))
	  ((null? l2) (revappend l1 l3))
	  (else
	   (let ((x1 (car l1))
		 (x2 (car l2)))
	     (if (< x1 x2) 
		 (merge (cdr l1) l2 (cons x1 l3))
		 (merge l1 (cdr l2) (cons x2 l3))))))))

(define mergesort
  (lambda (l)
    (cond ((null? l) l)
	  ((null? (cdr l)) l)
	  (else
	   (let ((p (split l '() '())))
	     (reverse (merge (mergesort (car p)) 
			     (mergesort (cdr p)) '())))))))

(define y (generate 100 '()))

(define x (write (mergesort y)))
	       
	
		   
