(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew,                                     *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* talout.mli
 * Useful functions for programs to write TAL modules out and call an
 * external verifier/assembler/linker.
 *
 *)

val object_file_suffix : string;;
val library_suffix : string;;
val default_executable : string;;

val runtime : string ref;;
val set_runtime : string -> unit;;
val includes : string list ref;;     (* Stored in reverse order *)
val add_include : string -> unit;;

(* write_x modulename filename x *)
val write_int : string -> string -> Tal.tal_int -> unit;;
val write_imp : string -> string -> Tal.tal_imp -> unit;;

(* print actual system commands executed to stdout or not *)
val verbose_sys_commands : bool ref;;
(* MS = use microsoft's assembler/linker, TALC = use ours *)
type bintool = MS | TALC;;
val asm_bintool : bintool ref;;
val link_bintool : bintool ref;; (* Only MS available *)
type binformat = COFF | ELF;;
val objformat : binformat ref;;

(* verify talfilename *)
val verify : string -> bool;;
(* asm talfilename objectfilename? *)
val asm : string -> string option -> bool;;
val verify_and_asm : string -> string option -> bool;;
(* link objectfilenames executablefilename *)
val link : string list -> string -> bool;;

(* EOF: talout.mli *)
