(**********************************************************************)
(* (c) Greg Morrisett, Steve Zdancewic                                *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* regrewrite.mli
 *
 * Utility functions for rewriting control flow graphs.
 *)

open Tal
open Cfg
open Regifg

(* Adds spill code to the given control flow graph based on the information *)
(* in the given interference graph.  If there are no live-ranges in the *)
(* spilled field, this function is the identity. *)
val rewrite_spills : cf_graph -> if_graph -> cf_graph

(* Removes redundant Mov instructions in the program, replacing them with *)
(* coercions if necessary. *)
val cleanup : cf_graph -> cf_graph

(* Performs a substitution on registers for a given control flow graph given *)
(* A mapping from registers to registers. *)
val rewrite_regs : cf_graph -> (reg, reg) Dict.dict -> cf_graph

(* Given a control flow graph in which every function has at most one return *)
(* value passed in a (virtual) register, returns the control flow graph with *)
(* Eax used to return values instead. *)
val rewrite_returns : cf_graph -> cf_graph

(* Given a control flow graph which has had register allocation performed on it *)
(* rewrite the cfg so that all registers live across procedure calls are saved. *)
val save_live_regs : cf_graph -> unit

(* EOF: regrewrite.mli *)
