(**********************************************************************)
(* (c) Greg Morrisett, Steve Zdancewic                                *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* talutil.mli
 *
 * Utility functions for manipulating TAL types.  (Mainly stacks and registers)
 *)

open Numtypes;;
open Tal

val mov_reg_slot : reg -> int32 -> instruction
val mov_slot_reg : int32 -> reg -> instruction
val stack_alloc  : int32 -> instruction
val stack_free   : int32 -> instruction

val junk_con    : con
val var_con     : Identifier.identifier -> con
val code_con    : register_state -> con
val empty_stack : con

val get_stack_con : register_state -> con
val set_stack_con : register_state -> con -> register_state

exception Stack
val cons_stack : con -> con -> con
val stack_is_empty    : con -> bool
val hd_stack          : con -> con
val tl_stack          : con -> con
val pop_stack         : con -> int32 -> con
val insert_stack      : con -> int32 -> con -> con
val insert_list_stack : con -> int32 -> con list -> con
val stack_size        : con -> int32

val get_code    : con -> con
val set_code    : con -> con -> con
val get_rs      : con -> register_state
val get_rs_copt : con option -> register_state

val get_type_arglist : con option -> con list
val cons_n_junks     : con -> int -> con

val get_stack         : con -> con
val get_return_rs     : con -> register_state
val get_registers     : register_state -> reg Set.set
val get_arg_registers : con -> reg Set.set
val get_ret_registers : con -> reg Set.set

val delete_regset_from_rs : reg Set.set -> register_state -> register_state

val make_var_subst : con -> coercion list -> 
  (Identifier.identifier, con) Dict.dict

val compare_stacks : Talctxt.ctxt -> con -> con -> (int32 list * con)

val block_type_to_ctxt : Talctxt.ctxt -> con option -> Talctxt.ctxt

val elim_stack_slots : bool list -> con -> con
val fix_cl : Talctxt.ctxt -> coercion list -> (con -> con) -> coercion list

(* EOF talutil.mli *)
