   
(**********************************************************************)
(* (c) Greg Morrisett, Dan Grossman, Steve Zdancewic                  *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* cfgopt.mli *)

(* Assumes liveness analysis has already been performed.  This pass   *)
(* is necessary for TAL code to typecheck and hence cannot be turned  *)
(* off.                                                               *)
val remove_dead_types : Cfg.cf_graph -> unit

(* Assumes liveness analysis has already been performed.              *)
val remove_dead_code : Cfg.cf_graph -> unit

(* Iteratively elims dead blocks *)
val remove_dead_blocks : Cfg.cf_graph -> unit

(* Performs simple block optimization and dead-code elimination.      *)
(* Doesn't assume that liveness analysis has been performed, performs *)
(* liveness analysis before exit.                                     *)
val peephole         : Cfg.cf_graph -> unit
val blockOptimize    : Cfg.cf_block -> unit
val jumpthread       : Cfg.cf_graph -> unit

(* EOF cfgopt.mli *)
