(define revappend
  (lambda (x y)
    (if (null? x) y
	(revappend (cdr x) (cons (car x) y)))))

(define reverse
  (lambda (x)
    (revappend x '())))

(define map
  (lambda (f x)
    (if (null? x) '() (cons (f (car x)) (map f (cdr x))))))

(define print-digit (lambda (x) (write-char x)))

(define digits
  (lambda (x cs)
    (if (= x 0) cs
	(let ((y (/ x 10))
	      (d (- x (* y 10)))
	      (c (integer->char (+ d (char->integer (string-ref "0" 0))))))
	  (digits y (cons c cs))))))

(define print-int
  (lambda (x)
    (cond ((= x 0) (write "0"))
	  ((< x 0) (begin (write "-") (print-int (- 0 x))))
	  (else (map print-digit (digits x '()))))))

