#!bash

## MASM

for i in parse tuple; do popcorn --generate-tal-only $i.pop; done
for i in ast queue; do popcorn -c $i.pop; done
for i in check_do fact fact2 fib test3 test_array; do
  popcorn -o $i.exe $i.pop
done
popcorn -o fact3.exe fact3.pop fact3_m.pop
popcorn -o global.exe global.pop global2.pop
popcorn -o test_list.exe list.pop test_list.pop

## TALC Assembler

popcorn --TALC -c parse.pop
for i in check_do fact fact2 fib test3 test_array tuple; do
  popcorn --TALC -o $i.exe $i.pop
done
popcorn --TALC -o fact3.exe fact3.pop fact3_m.pop
popcorn --TALC -o global.exe global.pop global2.pop
popcorn --TALC -o test_list.exe list.pop test_list.pop

### Run tests

check_do
fact
fact2
fact2 6
fact2 10
fact3
fact3 6
fact3 10
fib
for i in 0 1 2 3 4 5 6 7 8 9; do fib $i; done
global
test3
test3 6
test3 10
test_array
test_list
test_list 100
tuple
tuple 8 5

# EOF: runtests.bash
