(**********************************************************************)
(* (c) Greg Morrisett, Steve Zdancewic                                *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* cfginstr.mli
 *
 * Implements some useful functions for extracting information from
 * TAL instructions
 *)

open Tal
open Set

(* Takes an instruction and returns the set of virtual registers *)
(* defined and used in the instruction.  Takes into account the *)
(* "implicit" register usage such as EDX in MUL.  This function *)
(* does NOT look at the type annotations on the instruction or  *)
(* include the register ESP in any set returned *)
val def_use : instruction -> (reg set * reg set)

(* Returns true if the instruction is a register to register move, *)
(* false otherwise *)
val is_move : instruction -> bool

(* EOF cfginstr.mli *)
