(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew,                                     *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* Talutil
 * Useful error printing and dumping functions to share across tools.
 *)

let tal_print_options = 
  { Talpp.style = Talpp.MASM; Talpp.kinds = true; Talpp.cons = true }

let dumptalm name talm = 
  Talpp.print_tal_imp Format.std_formatter name tal_print_options talm;
  Format.print_newline ()
;;

let dumpreaderror name lb x =
  match x with
    Parsing.Parse_error ->
      print_string
    	(Printf.sprintf "%s: line %d(%d): " name !Tallex.line
	   (try Lexing.lexeme_start lb with _ -> 0));
      print_string "syntax error"; print_newline (); raise Talctxt.Talfail
  | Failure s ->
      print_string
    	(Printf.sprintf "%s: line %d(%d): " name !Tallex.line
	   (try Lexing.lexeme_start lb with _ -> 0));
      print_string "parser/scanner failure: "; print_string s;
      print_newline (); raise Talctxt.Talfail 
  | x -> raise x
;;

(* EOF: talutil.ml *)
