(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew,                                     *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* Talicache
 * Caches read interfaces from the file system
 *)

open Talutil;;

(* Include directories to search for interfaces.
 * Always search current directory, then the includes, then the runtime
 * directory.
 *)

let includes = ref [];;
let add_include s = includes := s :: !includes;;

let find_interface s =
  if Sys.file_exists s then
    s
  else
    let rec loop dirs =
      match dirs with
	[] ->
	  let s1 = Filename.concat !Talcomp.runtime s in
	  if Sys.file_exists s1 then s1 else begin
	    print_string s; print_string ": no such interface";
	    print_newline (); raise Talctxt.Talfail
	  end
      |	dir::dirs ->
	  let s1 = Filename.concat dir s in
	  if Sys.file_exists s1 then s1 else loop dirs
    in loop (List.rev !includes)
;;

let talintcache = Hashtbl.create 13;;

let rec get_tali intref =
  try Hashtbl.find talintcache intref
  with Not_found ->
    let tali = read_tali intref in
    Hashtbl.add talintcache intref tali;
    tali
and read_tali intref =
  let fn = find_interface intref in
  let ic = open_in fn in
  let lb = Lexing.from_channel ic in
  try
    Tallex.reset_lexer ();
    let tali = Talparser.tal_int Tallex.main lb in
    close_in ic;
    tali
  with x -> dumpreaderror fn lb x
;;

(* EOF: talicache.ml *)
