(**********************************************************************)

(* (c) Greg Morrisett, Neal Glew,                                     *)

(*     June 1998, all rights reserved.                                *)

(**********************************************************************)



(* talcomp.ml

 * TAL compilation functions

 *

 *)



let runtime =

  ref (try Sys.getenv "TALCLIB" with Not_found -> "")

;;



let set_runtime s = runtime := s;;



let write_int modname filename talint =

  Format.set_margin 9999;

  let oc = open_out filename in

  Format.set_formatter_out_channel oc;

  Talpp.print_tal_int Format.std_formatter modname Talpp.std_options talint;

  Format.print_flush ();

  Format.set_formatter_out_channel stdout;

  close_out oc;

  Format.set_margin 79;

  ()

;;



let write_imp modname filename talimp =

  Format.set_margin 9999;  (* JGM: too large a value causes stack overflow *)

  let oc = open_out filename in

  Format.set_formatter_out_channel oc;

  Talpp.print_tal_imp Format.std_formatter modname Talpp.std_options talimp;

  Format.print_flush ();

  Format.set_formatter_out_channel stdout;

  close_out oc;

  Format.set_margin 79;

  ()

;;



let asm verbose filename objfile =

  let objfile = match objfile with None -> "" | Some fn -> " /Fo"^fn in

  let cmd =

    "ml /nologo /coff /I" ^ (!runtime) ^ " /c /Fl /Sc" ^ objfile ^

    " /Ta " ^ filename in

  if verbose then begin print_string cmd; print_newline () end;

  Sys.command cmd;

  ()

;;



let link verbose objfiles exename =

  let cmd =

    "link /nologo /subsystem:console /libpath:" ^ !runtime ^

    " /out:" ^ exename ^ " tal_start.obj " ^

    (List.fold_right (fun fn s -> fn^" "^s) objfiles "") ^

    "stdlib.obj tal_util.obj gc.lib" in

  if verbose then begin print_string cmd; print_newline () end;

  Sys.command cmd;

  ()

;;



(* EOF: talcomp.ml *)

