; TAL macros
;==================================================
; To bracket TAL code with appropriate directives
_begin_TAL MACRO
	.586P
	.MODEL	FLAT, SYSCALL
	EXTERN	C GC_malloc :NEAR, _array_bounds_error :NEAR, \
                _out_of_memory :NEAR, die :NEAR
ENDM
_end_TAL MACRO
ENDM
;==================================================
; To get top level typing information in
LABELTYPE MACRO	a1
ENDM
TAL_IMPORT MACRO intref:REQ
	@@@xport TEXTEQU <>
	INCLUDE	intref
ENDM
TAL_EXPORT MACRO intref:REQ
	@@@xport TEXTEQU <X>
	INCLUDE	intref
ENDM
	OPTION	NOKEYWORD:<TYPE>
TYPE	MACRO	lcd:REQ
ENDM
VAL	MACRO	l:REQ,c:REQ
	IFNB @@@xport
	PUBLIC	l
	ELSE
	EXTERN	l :NEAR
	ENDIF
ENDM
;==================================================
; Code/Data switching
DATA	MACRO
	.DATA
	ASSUME CS:_DATA
ENDM
CODE	MACRO
	.CODE
ENDM
;==================================================
; Instructions
; *** ASSUMPTION: first word of array is length, rest are entries
ALEN	MACRO	size:REQ, reg:REQ, array:REQ
	MOV	reg,DWORD PTR [array+0]
ENDM
ASUB	MACRO	size:REQ, dest:REQ, array:REQ, index:REQ
	CMP	index,DWORD PTR [array+0]
	JAE	_array_bounds_error
	MOV	dest,[array+size*index+04]
ENDM
AUPD	MACRO	size:REQ, array:REQ, index:REQ, src:REQ
	CMP	index,DWORD PTR [array+0]
	JAE	_array_bounds_error
	MOV	[array+size*index+04],src
ENDM
; *** ASSUMPTION: exntag of an exn is in first word of record
BEXN	MACRO	reg:REQ, exntag:REQ, label:REQ
	CMP	DWORD PTR [reg+0],exntag
	JNE	label
ENDM
make_jmp MACRO	cc:REQ
	EXITM	@CATSTR(<J>,<cc>)
ENDM
BTAGI	MACRO	cc:REQ, reg:REQ, tag:REQ, label:REQ
	CMP	reg,tag
	make_jmp(cc)	label
ENDM
; *** ASSUMPTION: tag of variant is in first word of record
BTAGVAR	MACRO	cc:REQ, reg:REQ, tag:REQ, label:REQ
	CMP	DWORD PTR [reg+0],tag
	make_jmp(cc)	label
ENDM
COERCE	MACRO	arg:REQ
ENDM
FALLTHRU MACRO	gamma:REQ
ENDM
MALLOC	MACRO	reg:REQ, size:REQ, types:REQ
	PUSH	reg
	PUSHAD
	PUSHD	size
	CALL	GC_malloc
	LEA	ESP,[ESP+04]
	TEST	EAX,EAX
	JZ	_out_of_memory
	MOV	[ESP+32],EAX
	POPAD
	POP	reg
ENDM
UNPACK	MACRO	tvar:REQ, reg:REQ, value:REQ
IFDIFI <reg>, <value>
	MOV	reg, value
ENDIF
ENDM
;==================================================
; Operands
; Virtual registers - MASM shouldn't see these, generate an error
R	MACRO	num:REQ
	.ERR	"Use of virtual register"
ENDM
RL	MACRO	num:REQ
	.ERR	"Use of virtual register"
ENDM
S	MACRO	tag:REQ
	EXITM	<tag>
ENDM
;==================================================
; Data Items
EXNNAME	MACRO
	DD	?
ENDM
;==================================================
; Coercions
pack	MACRO	t1:REQ, arg:REQ, t2:REQ
	EXITM	<arg>
ENDM
tapp	MACRO	arg:REQ, type:REQ
	EXITM	<arg>
ENDM
roll	MACRO	type:REQ, arg:REQ
	EXITM	<arg>
ENDM
unroll	MACRO	arg:REQ
	EXITM	<arg>
ENDM
sum	MACRO	type:REQ, arg:REQ
	EXITM	<arg>
ENDM
rollsum	MACRO	type:REQ, arg:REQ
	EXITM	<arg>
ENDM
rec	MACRO	arg:REQ
	EXITM	<arg>
ENDM
exn	MACRO	arg:REQ
	EXITM	<arg>
ENDM
array	MACRO	arg:REQ
	EXITM	<arg>
ENDM
slot	MACRO	num:REQ, arg:REQ
	EXITM	<arg>
ENDM
; This is for malloc arg
exnname	MACRO	con:REQ
	EXITM	exnname
ENDM
;==================================================
; EOF: tal.inc
