(* Status;

   1. Everything needs to be tested!!!

   2. The code for union switch is a mess and works by some small miracle (i.e. there is probably some case for which it does not work. I need to think about this code a bit before I rewrite it.)

   3. Should really try to optimize this code a bit.  It is really bad.

*)



module T = Tal ;;

module P = Popsyntax ;;

module PT = Poptype ;;

module Id = Identifier ;;



exception Unimplemented of string ;;

exception Impossible of string ;;



let unimpl s = Unimplemented s;;

let impos s = Impossible s;;



(* Abbreviations *)

let dc = T.defcon ;;



(* The global_env tracks definitions of types and types of global variables.

 * The local_env tracks the types and stack positions (in bytes relative to

 * the current stack pointer) of local variables.  The stack_type tracks

 * the current type of the stack.

 * 

 * The break label, when Some(lab,n), is the label that a break should

 * jump to.  However, before jumping, the break should pop s - n local 

 * variables from the stack, where s is the current size of the stack.

 * Similarly, the continue label, when Some(lab,n) is the label that a 

 * continue should jump to.  

 *)



type id = Id.identifier ;;



(*

type ufield_void_info = 

    { void_tag: int;

    } 

*)



type stack_or_reg = TopStack | Stack of int | Register of T.reg ;;



type union_info = 

    { void_infos: (P.field_name * int) list;

      value_infos: (P.field_name * (int * T.con)) list;

      union_con: T.con;

      union_null: bool

    } 



type sfield_info = (T.con * T.capability);;



type struct_info =

    { sfield_infos: (P.field_name * int * sfield_info) list;

      struct_null: bool;

      struct_con: T.con

    } 



type type_info =

    { unions: (P.type_name, union_info) Dict.dict;

      structs: (P.type_name, struct_info) Dict.dict

    } 

	

type env = 

    { global_env: PT.global_env;

      local_env: (P.var * (T.con * int)) list;

      args_on_stack: int;

      stack_type: T.con;

      break_label: (id*int) option;

      continue_label: (id*int) option;

      type_info: type_info;

      mutable regs: T.register_state

    } 



(*********** global vars ***************)



let export_cons: T.int_con list ref = ref [] ;;

let export_vals:(id * T.con) list ref = ref [] ;;

let import_cons: T.int_con list ref = ref [] ;; 

let import_vals: (id * T.con) list ref = ref [];; 



(********************************************************************)

(* code generation utilities                                        *)

(********************************************************************)

(* clean up an identifier to make it a label *)

let clean x =

  let x = String.copy x in

  let rec loop i = 

    if i < String.length x then

      let c = String.get x i in

      let j = Char.code c in

      let k = 

	if (j >= Char.code 'a' & j <= Char.code 'z') or

	   (j >= Char.code 'A' & j <= Char.code 'Z') or

           (j >= Char.code '0' & j <= Char.code '9') then j

	else if (j = Char.code '-') or (j = Char.code '_') 

	then Char.code '_'

	else Char.code 'X'

      in (String.set x i (Char.chr k); loop (i+1))

    else ()

  in (loop 0; x)



(* pid2tid : P.var -> T.var 

   Takes a non-type popcorn variable and returns a TAL id.

   *)

let pid2tid p = let s = clean p in (Id.id_of_string ("_" ^ s)) ;;



let null_name s = Id.id_of_string ((clean ("null_" ^ s)) ^ "$");;

(* Takes a type name in popcorn and returns a TAL id. *)

let name s = Id.id_of_string ((clean  s) ^ "$") ;;



(* Converts a list of registers and constructors into a constructor for a code label. *)

let list_to_ctxt (regs : (T.reg*T.con) list) = 

  dc(T.Ccode (List.fold_right (fun (r,c) d -> Dict.insert d r c) regs 

		  (Dict.empty compare)));;



let add_to_state state reg con = Dict.insert state reg con ;;



let state_to_ctxt state = dc(T.Ccode state) ;;



(*XXXX - Variable used for the stack always. *)

let stack_v = Id.id_of_string "s";;

let stack_c = dc (T.Cvar stack_v) ;;



let int_con = dc (T.Cprim (T.PCbytes T.Byte4));;

let bool_con = dc (T.Csum {T.sum_tags = [0;1]; T.sum_vt = None});;

let string_con = dc (T.Cprim (T.PCbytearray T.Byte1));;

let char_con = int_con;;

let array_con c = dc (T.Capp (dc (T.Cprim T.PCarray), c));;

let name_con n= dc (T.Clab (name n));;

let opt_con c= dc(T.Csum { T.sum_tags=[0]; 

			    T.sum_vt=Some(T.Tuple[(c,T.Read,T.Init)])

			 }) ;;



let default_con_blocks = [];;

(* The following does not work because we cannot convert a label to a con

   in any reasonable way. If I can convince someone (Neal?) to fix this 

   great! *)

(*

let real_int_con = dc (T.Cprim (T.PCbytes T.Byte4));;

let real_bool_con = dc (T.Csum {T.sum_tags = [0;1]; T.sum_vt = None});;

let real_string_con = dc (T.Cprim (T.PCbytearray T.Byte1));;

let real_char_con = real_int_con;;

let real_array_con = 

  begin

    let c = Id.id_new "c" in

    dc (T.Clam (c,T.K4byte,dc (T.Capp (dc (T.Cprim T.PCarray), 

				       dc (T.Cvar c)))))

  end ;;

let real_name_con = 

  begin 

    let c = Id.id_new "c" in

    (dc (T.Clam (c,T.K4byte,dc (T.Cvar c))))

  end ;;

let real_opt_con = 

  begin

    let c = Id.id_new "c" in

    dc (T.Clam (c,T.K4byte, 

		dc(T.Csum { T.sum_tags=[0]; 

			    T.sum_vt=Some(T.Tuple[(dc (T.Cvar c),

						   T.ReadWrite,T.Init)])

			  })))

  end;;



let int_con_id = Id.id_of_string "int$";;

let bool_con_id = Id.id_of_string "bool$";;

let string_con_id = Id.id_of_string "string$";;

let char_con_id = Id.id_of_string "char$";;

let array_con_id = Id.id_of_string "arr$";;

let name_con_id = Id.id_of_string "struct$";;

let opt_con_id = Id.id_of_string "opt$";;



let int_con = dc (T.Clab int_con_id) ;;

let bool_con = dc (T.Clab bool_con_id) ;;

let string_con = dc (T.Clab string_con_id) ;;

let char_con = dc (T.Clab char_con_id) ;;

let array_con c = dc (T.Capp (dc (T.Clab array_con_id),c)) ;;

let name_con n = dc (T.Capp (dc (T.Clab name_con_id),

			     dc (T.Clab (pid2tid n))));;

let opt_con c = dc (T.Capp (dc (T.Clab opt_con_id),c)) ;;



let default_con_blocks = [ (int_con_id,T.K4byte,real_int_con);

			   (bool_con_id,T.K4byte,real_bool_con);

			   (string_con_id,T.K4byte,real_string_con);

			   (char_con_id,T.K4byte,real_char_con);

			   (array_con_id,T.Karrow(T.K4byte,T.K4byte),

			    real_array_con);

			   (name_con_id,T.Karrow(T.K4byte,T.K4byte),real_name_con);

			   (opt_con_id,T.Karrow(T.K4byte,T.K4byte),real_opt_con)];;

*)

let main_id = "main";;

let main_label = Id.id_of_string "__main$";;

let pop_exit_label = Id.id_of_string "_pop_exit";;



let never_null_label = Id.id_of_string "_pop_never_null";;

let never_null_con = list_to_ctxt [];;





let tal_main = Id.id_of_string "_tal_main";;

let sptr_con = dc(T.Cprim T.PCstackptr);;

let sptr c = dc (T.Capp (sptr_con,c)) ;;



let new_array_label = Id.id_of_string "_new_array";;

let new_array_con = 

  begin

    let arr_typ = Id.id_new "a" in

    let arr_typ_con = dc (T.Cvar arr_typ) in

    let stack = dc (T.Ccons (int_con, dc (T.Ccons (arr_typ_con,stack_c)))) in

    let ret_state = list_to_ctxt[ (T.Eax,array_con arr_typ_con);

				  (T.Esp,sptr stack)] in

    let initial_state = list_to_ctxt [T.Esp, 

				  sptr (dc (T.Ccons(ret_state,stack)))] in

			      

    let con' = dc (T.Cforall (arr_typ,T.K4byte,initial_state)) in

    let con = dc (T.Cforall (stack_v,T.Kstack,con')) in

    con

  end ;;



let (tal_main_code_block,tal_main_con) = 

  begin

(* let tal_main_con = list_to_ctxt [(T.Esp,sptr (dc T.Cempty))];;*)

    let tal_main_state = (dc T.Cempty) in

    let tal_main_con = list_to_ctxt [(T.Esp,sptr tal_main_state)] in

    let tal_main_code = [|T.Call (T.Addr main_label,[T.Tapp tal_main_state]);

			  T.Mov (T.Reg T.Eax,(T.Immed 0,[]));

			  T.Jmp (T.Addr pop_exit_label,[])

			|] in

    ((tal_main,tal_main_con,tal_main_code),tal_main_con)

  end ;;





let default_import_vals = [ (new_array_label,new_array_con) ];;



let nonsense_id = Id.id_new "nonsense";;

let nonsense_con = dc T.Cempty;;



(* list of code blocks (in reverse order) *)

let code_blocks : T.code_block list ref = ref [];;

let data_blocks : T.data_block list ref = ref [];;

(* current label whose instructions are in current_instrs *)

let current_label : (id * T.con) ref = ref (nonsense_id,nonsense_con);;

(* instructions kept in reverse order *)

let current_instrs : T.instruction list ref = ref [];;



let reset_generator () =

  export_cons := [];

  export_vals := [];

  import_cons := [];

  import_vals := [];



  code_blocks := [];

  data_blocks := [];

  current_label := (nonsense_id,nonsense_con); (* Should not be used. *)

  current_instrs := [];

  ()

;;

(* emit one instruction *)

let emit i = current_instrs := i::(!current_instrs);;



let bool_false = (T.Tag 0,[T.Tosum bool_con]);;

let bool_true =  (T.Tag 1,[T.Tosum bool_con]);;

let branch_coercion = [T.Tapp stack_c] ;;



let add_string s = 

  begin

    let lab = Id.id_new "string" in

    let len = String.length s in

    data_blocks := (lab,

		    Some (dc (T.Cprim (T.PCbytearray T.Byte1))),

		    ([T.Dtag (len,[]); T.Dbytes s],

		     [T.Toarray])) 

       :: !data_blocks;

    lab

  end



(* for emitting comments *)

let print_comments = ref true;;

let comment s = if (!print_comments) then emit(T.Comment("\t"^s)) else ();;



(* emit a label -- this packages up the current label and list of

 * instructions as a code block, pushes that code block on the

 * list of code blocks, and starts a new instruction list. *)

let flush_code() =

  let instrs = Array.of_list (List.rev (!current_instrs)) in

  let (cl,clc) = !current_label in

  begin

    code_blocks := (cl,clc,instrs)::(!code_blocks);

    current_instrs := []

  end

let emit_lab env l = 

  begin

    let stack_state = add_to_state env.regs T.Esp (sptr env.stack_type) in

    let l_con = dc (T.Cforall (stack_v,T.Kstack,state_to_ctxt stack_state)) in

    flush_code();

    current_label := (l,l_con)

  end



let negate_cc cc = 

  match cc with

    T.Eq -> T.NotEq

  | T.NotEq -> T.Eq

  | T.GreaterEq -> T.Less

  | T.Greater -> T.LessEq

  | T.LessEq -> T.Greater

  | T.Less -> T.GreaterEq

  | _ -> raise (impos "optimizer found unexpected condition code")



let empty_regs = Dict.empty T.compare_regs ;;





let con2field c = (c,T.Read,T.Init) ;;



exception Void_Type;; (* Void_Types have no TAL constructor. *)



(* typ2con : env -> P.typ -> T.con *)

(* Given a popcorn type, it produces the equivalent Tal type (constructor) 

   We assume that all type names have been lettyped already.

   We make void a B4 although we may want to get rid of this later.

*) 

let rec typ2con env t =

  begin

    match t with 

      P.VoidType -> (raise Void_Type)

    | P.IntType -> int_con

    | P.BooleanType -> bool_con

    | P.StringType -> string_con

    | P.CharType -> char_con

    | P.ArrayType t' -> (array_con (typ2con env t'))

    | P.FnType  (t',tl) -> fst (fun_con env t' tl)

    | P.TupleType ts -> 

	T.defcon(T.Cprod(List.map (fun t -> (typ2con env t,T.Read,T.Init)) ts))

    | P.NamedType n -> (name_con n)

  end

and fun_con env ret_typ params =

  begin

    (* Our calling convention pushes all arguments from right to left onto 

       the stack, with the return value in EAX *)

    let rec map params a =

      begin

	match params with

	  [] -> a 

	| hd :: tl ->

	    try

	      (map tl ((typ2con env hd) :: a))

	    with Void_Type -> (map tl a)

      end in

    let p_cons = List.rev (map params []) in

    let stack_p = (List.fold_right (fun c1 c2 -> dc (T.Ccons (c1,c2))) 

		     p_cons stack_c)  in

    let ret_state = 

      begin

	try

	  list_to_ctxt [(T.Eax,typ2con env ret_typ);(T.Esp,sptr stack_p)]

      	with Void_Type -> list_to_ctxt [T.Esp,sptr stack_p] 

      end in

    let stack_on_entry = dc (T.Ccons (ret_state,stack_p)) in

    let fun_state = list_to_ctxt [T.Esp,sptr stack_on_entry] in

    let lab_con = dc (T.Cforall (stack_v, T.Kstack, fun_state)) in

    (lab_con,stack_on_entry)

  end



let exp2typ e =

  begin

    match e.P.exp_typ with

      None -> (raise (impos "Expression without type!!"))

    | Some t -> t

  end;;



let exp2con env e = (typ2con env (exp2typ e));;



let fallthru() = emit(T.Fallthru[stack_c])





let add_reg env reg con = env.regs <- (Dict.insert env.regs reg con) ;;

let lookup_reg env reg = Dict.lookup env.regs reg ;;

let rm_reg env reg = env.regs <- (Dict.delete env.regs reg) ;;



let copy_env env = 

  { global_env = env.global_env;

    local_env = env.local_env;

    args_on_stack = env.args_on_stack;

    stack_type = env.stack_type;

    break_label = env.break_label;

    continue_label = env.continue_label;

    type_info = env.type_info;

    regs = env.regs

  } 



(* push : env -> reg -> env, pushes reg onto the stack.

   If the current register state (env.regs) does not contain the register

   does nothing. Otherwise updates the stack con, and removes reg from env.regs *)  

let push env reg =

  begin

    try

      let reg_con = Dict.lookup env.regs reg in

      let new_local_env = 

      	(List.map (fun (v,(c,i)) -> (v,(c,i+1))) env.local_env) in

      let new_stack_type = dc (T.Ccons (reg_con,env.stack_type)) in

      emit (T.Push (T.Reg reg, []));

    { global_env = env.global_env;

      local_env = new_local_env;

      args_on_stack = env.args_on_stack;

      stack_type = new_stack_type;

      break_label = env.break_label;

      continue_label = env.continue_label;

      type_info = env.type_info;

      regs = Dict.delete env.regs reg 

    } 

    with Dict.Absent -> env

  end

(* push_keep : env -> reg -> env, pushes reg onto the stack.

   If the current register state (env.regs) does not contain the register

   does nothing. Otherwise updates the stack con. *)  

let push_keep env reg =

  begin

    try

      let reg_con = Dict.lookup env.regs reg in

      let new_local_env = 

      	(List.map (fun (v,(c,i)) -> (v,(c,i+1))) env.local_env) in

      let new_stack_type = dc (T.Ccons (reg_con,env.stack_type)) in

      emit (T.Push (T.Reg reg, []));

    { global_env = env.global_env;

      local_env = new_local_env;

      args_on_stack = env.args_on_stack;

      stack_type = new_stack_type;

      break_label = env.break_label;

      continue_label = env.continue_label;

      type_info = env.type_info;

      regs = env.regs

    } 

    with Dict.Absent -> env

  end



(* pop : T.register -> () *)

(* emits the code to pop one word off the stack into the register. 

   Does not return an env since presumably we are restoring the env.

*)

let pop reg = emit(T.Pop (T.Reg reg)) ;;

(* pop freeing i stack slots. *)

let pop_free i = 

  if i>0

  then emit(T.ArithBin(T.Add,T.Reg T.Esp,T.Immed (4*i)))

  else ();;



(* peek - load the ith word from the top of the stack without popping. *)

let peek reg i = emit (T.Mov (T.Reg reg,(T.Prjr ((T.Esp,[]),4*i),[]))) ;;



(* add_local_var: var -> T.con -> env -> env *)

(* Adds the local variable var to the current environment.  

   Variable is already on the stack but stack-con has not been 

   updated, nor has local_env. 

*)

let add_local_var x con env =

  begin

     let new_local_env = (x,(con,0)) :: 

      (List.map (fun (x,(c,i)) -> (x,(c,i+1))) env.local_env) in

   let new_stack_type = dc (T.Ccons (con,env.stack_type)) in      

    { global_env = env.global_env;

      local_env = new_local_env;

      args_on_stack = env.args_on_stack;

      stack_type = new_stack_type;

      break_label = env.break_label;

      continue_label = env.continue_label;

      type_info = env.type_info;

      regs = env.regs

    } 

  end



let set_loop_labels env loopend looptest = 

  begin

  let stack_depth = List.length env.local_env in

    { global_env = env.global_env;

      local_env = env.local_env;

      args_on_stack = env.args_on_stack;

      stack_type = env.stack_type;

      break_label = Some (loopend,stack_depth);

      continue_label = Some (looptest,stack_depth);

      type_info = env.type_info;

      regs = env.regs

    } 

  end



let typ2struct_info env nt = 

  begin

    let n = match nt with

      P.NamedType n -> n

    | _ -> (raise (impos "typ2struct_info: struct without name."))

    in

    try

      Dict.lookup env.type_info.structs n

    with Dict.Absent -> (raise (impos "typ2struct_info: struct without info."))

  end;;



let typ2union_info env nt = 

  begin

    let n = match nt with

      P.NamedType n -> n

    | _ -> (raise (impos "typ2union_info: union without name."))

    in

    try

      Dict.lookup env.type_info.unions n

    with Dict.Absent -> (raise (impos "typ2union_info: union without info."))

  end;;



let struct_field_offset s_info f =

  begin

    let rec aux fields =

      match fields with

	[] -> (raise (impos "struct_field_offset: No such field"))

      |	((n,o,_)::tl) -> if n=f then o else (aux tl)

    in

    aux (s_info.sfield_infos)

  end;;



let mallocarg2con m =

  begin

    match m with

      T.Mprod fs -> 

      	begin

	  let rec aux fs a =

	    match fs with

	      [] -> List.rev a

	    | ((con,cap)::tl) -> aux tl ((con,cap,T.Uninit) :: a)

	  in

	  (aux fs [])

      	end

    | T.Mbytearray _ -> (raise (unimpl "mallocarg2con: Byte arrays"))

    | T.Mexnname c -> (raise (unimpl "mallocarg2con: Exnname"))

  end;;



(* Check that r != null, raise null exception if r == null. *)

let check_not_null r =

   begin

     emit(T.Btagi(r,0,(never_null_label,[]),T.Eq));

     emit(T.Coerce(r,[T.Fromsum]))

     (* do I need a coerce here? *)

   end;;



(* decl_named_type : P.var -> P.Scope -> T.con -> bool -> T.con_block *)

(* Imports and Exports whatever is necessary based on the scope and whether

   this con can be null or not. *)

let io_namedtype id scope null con =

  begin

    let label = name id in

    let null_label = null_name id in

    let null_val = T.Dtag(0,[T.RollTosum (name_con id)]) in

    let null_label_con = dc (T.Cprod [(name_con id,T.ReadWrite,T.Init)]) in  

    let null_data = (null_label,Some(null_label_con),([null_val],[])) in

    let int_con = (label,T.K4byte,T.ConcCon con) in

    begin

      match scope with

      	P.Public -> 

	  begin

	    export_cons := (int_con :: !export_cons);

	    if null 

	    then (data_blocks := (null_data :: !data_blocks);

		  export_vals := (null_label,null_label_con) :: !export_vals);

	    [(label,T.K4byte,con)]

	  end

      |	P.Extern ->

	  begin

	    import_cons := (int_con :: !import_cons);

	    if null 

	    then import_vals := (null_label,null_label_con) :: !import_vals;

	    []

	  end

    |	P.Static -> 

	  begin

	    if null then data_blocks := null_data :: (!data_blocks);

	    [(label,T.K4byte,con)]

	  end

    end

  end

(**************************Code Generation *******************************)

(* cg_bop : env -> P.Primop -> stack_or_reg -> con option *)

(* One value is assumed to be in Eax.  The other is either on the stack or

   in a register. 

   If the other value is on the top of the stack it is popped off the stack.

   Generate the code for the operation leaving the result in Eax. 

   Only for binary operators.

   Returns the constructor for the result if different from EAX. 

*)

let cg_bop env p sor =

  begin

    let get_val =

      match sor with

	TopStack -> (fun r -> pop r;r)

      |	Stack i -> (fun r -> peek r i;r)

      |	Register r -> (fun r' -> r)

    in

    match p with

      (P.Plus | P.Times | P.Minus | P.Bitand | P.Bitor | P.Bitxor) ->

	begin

	  let op = 

	    (match p with

	      P.Plus -> T.Add

	    | P.Times -> T.Imul2

	    | P.Minus -> T.Sub

	    | P.Bitand -> T.And

	    | P.Bitor -> T.Or

	    | P.Bitxor -> T.Xor

	    | _ -> (raise (impos "This is exhaustive!!"))) in 

	  let reg2 = get_val T.Ebx in

	  emit(T.ArithBin (op,T.Reg T.Eax,T.Reg reg2));

	  None

	end

    | (P.Bitlshift | P.Bitlrshift | P.Bitarshift) ->

	begin

	  let op = 

	    (match p with

	      P.Bitlshift -> T.Shl

	    | P.Bitlrshift -> T.Shr

	    | P.Bitarshift -> T.Sar

	    | _ -> (raise (impos "This is exhaustive"))) in

	  let reg2 = get_val T.Ecx in

	  (if not (reg2 = T.Ecx) then emit(T.Mov (T.Reg T.Ecx,(T.Reg reg2,[]))));

	  emit (T.ArithSR (op,T.Reg T.Eax, None));

	  None

	end

    | (P.Div | P.Mod ) -> 

	begin

	  let op = T.Idiv in

	  let reg2 = get_val T.Edx in

	  emit(T.ArithMD (op,T.Reg reg2));

	  begin

	    match p with 

	      P.Mod -> emit(T.Mov (T.Reg T.Eax, (T.Reg T.Edx,[])))

	    | P.Div -> ()

	    | _ -> (raise (impos "This is exhaustive!"))

	  end;

	  None

	end		

    | (P.Gt | P.Lt | P.Gte | P.Lte | P.Eq | P.Neq) ->

	begin

	  let op =

	    (match p with

	      P.Gt -> T.Greater

	    | P.Lt -> T.Less

	    | P.Gte -> T.GreaterEq

	    | P.Lte -> T.LessEq

	    | P.Eq -> T.Eq

	    | P.Neq -> T.NotEq

	    | _ -> (raise (impos "This is exhaustive!!")))in

	  let reg2 = get_val T.Ecx in

	  let aux_reg = if reg2 = T.Ebx then T.Ecx else T.Ebx in

	  emit (T.Mov (T.Reg aux_reg,(T.Reg T.Eax,[])));

          emit (T.Mov (T.Reg T.Eax,bool_false));

	  emit (T.Cmp (T.Reg aux_reg,T.Reg reg2));

	  emit (T.Setcc (op,T.Reg T.Eax));

	  Some(bool_con)

	end

    | _ -> (raise (impos "cg_exp: Binary Primop"))  

  end

(* For now all results are put in EAX and EAX is saved by 

   "caller" when needed. *)

let rec cg_exp env e = 

  begin

    match e.P.raw_exp with

      P.Const c ->

	begin

	  let (cgop,const_con) = 

	    (match c with

	      P.Int i -> ((T.Immed i,[]),int_con)

	    | P.Bool b -> ((if b then bool_true else bool_false),bool_con)

	    | P.String s -> 

		let lab = add_string s in 

		((T.Addr lab,[]),string_con)

	    | P.Char c -> ((T.Immed (Char.code c),[]),char_con)

	    | P.Null n -> 	

		let t_n = null_name n in

		((T.Prjl ((t_n,[]),0),[]),name_con n))

	  in 

	  emit(T.Mov(T.Reg T.Eax,cgop));

	  (add_reg env T.Eax const_con)

	end  

    | P.ConstArray (es,ot) -> 

	begin

	  let size = List.length es in

	  let scale = 4 in

	  let real_size = (size * scale) + 4 in (* 4 for tag. *)

	  let con = 

	    match (ot,es) with

	      (None,hd::tl) -> (exp2con env hd)

	    | (Some t,_) -> (typ2con env t)

	    | _ -> (raise (impos "cg_exp: ConstArray: Without type."))

	  in

	  let field = (con,T.ReadWrite) in

	  let rec aux es a=

	    match es with [] -> a | (hd::tl) -> (aux tl (field::a)) in

	  let mfs = (dc (T.Cprim (T.PCtag (size))),T.Read) 

	    :: (aux es []) in

	  let mallocarg = T.Mprod mfs in

	  emit(T.Malloc (T.Ebx,real_size,mallocarg));

	  let mfs2con mfs i =

	    begin

	      let mf2fi (con,cap) = (con,cap,T.Init) in

	      let mf2fu (con,cap) = (con,cap,T.Uninit) in

	      let rec aux mfs i = 

		(match mfs with

		  [] -> []

		| (hd::tl) -> 

		    (if i=0 

		    then (mf2fi hd) :: (aux tl i)

		    else (mf2fu hd) :: (aux tl (i-1))))

	      in

	      dc (T.Cprod (aux mfs i))

	    end in

	  add_reg env T.Ebx (mfs2con mfs (size+1));

	  let env' = push env T.Ebx in

	  let rec cg_fields env' elt es =

	    begin

	      match es with

		[] -> env'

	      |	(hd::tl) -> 

		  begin

		    let offset = (elt*scale) in

		    cg_exp env' hd;

		    pop T.Ebx;	    

		    emit(T.Mov (T.Prjr ((T.Ebx,[]),offset),(T.Reg T.Eax,[])));

		    add_reg env T.Ebx (mfs2con mfs elt);

		    let env'' = push env T.Ebx in

		    (cg_fields env'' (elt-1) tl)

		  end

	    end in

	  let env'' = (cg_fields env' size (List.rev es)) in

	  pop T.Eax;

	  emit(T.Mov (T.Prjr ((T.Eax,[]),0),(T.Tag (size),[])));

	  emit(T.Coerce(T.Eax,[T.Toarray]));

	  add_reg env T.Eax (array_con con)

	end

    | P.Var x ->

	begin

	  try 

           let (c,offset) = List.assoc x env.local_env in

	   emit (T.Mov(T.Reg T.Eax,(T.Prjr((T.Esp,[]),4*offset),[])));

	   (add_reg env T.Eax c)

	  with Not_found -> 

	    begin

	      try 

	      	let t = Dict.lookup env.global_env.PT.globals x in

	      	emit(T.Mov(T.Reg T.Eax,(T.Addr (pid2tid x),[])));

	      	(add_reg env T.Eax (typ2con env t))

	      with Dict.Absent -> (raise (impos "cg_exp: Var without type."))

	    end

	end

    | P.Primop(p,[e]) ->

	begin

	  cg_exp env e;

	  let r = T.Eax in 

	  match p with

	    P.Not ->

	      begin

		emit(T.Mov (T.Reg T.Ebx, bool_false));

		emit(T.Cmp (T.Reg T.Eax, T.Reg T.Ebx));

		emit(T.Setcc(T.Eq,T.Reg T.Eax))

	      end

	  | P.Bitnot -> (emit(T.ArithUn (T.Not,T.Reg T.Eax)); 

			 add_reg env T.Eax int_con)

	  | P.Size -> 

	      begin

		let scale = 

		  begin

		    match e.P.exp_typ with

		      None -> (raise (impos "Expressionless type."))

		    | Some(P.StringType) -> T.Byte1

		    | _ -> T.Byte4

		  end in

		emit(T.Alen (scale,T.Eax,T.Reg T.Eax));

		(add_reg env T.Eax int_con)

	      end

	  | P.Ord -> (add_reg env T.Eax int_con)

	  | P.Chr -> (add_reg env T.Eax char_con)

	  | _ -> (raise (impos "cg_exp: Unary op expected."))

	end

    | P.Primop(p,[e1;e2]) ->

	begin

	  cg_exp env e2;

	  let env' = push env T.Eax in

	  cg_exp env' e1;

	  match (cg_bop env' p TopStack) with

	    None -> ()

	  | Some con -> (add_reg env T.Eax con)

	  

	end

    | P.Primop _ -> (raise (impos "cg_exp: ?? Primop"))

    | P.Conditional (e1,e2,e3) ->

	begin

	  let false_lab = Id.id_new "iffalse" in

      	  let end_lab = Id.id_new "ifend" in

	  cg_exp env e1;

	  emit (T.Btagi(T.Eax,0,(false_lab,branch_coercion),T.Eq));

	  cg_exp env e2;

	  emit (T.Jmp(T.Addr end_lab,branch_coercion));

	  env.regs <- empty_regs;

	  emit_lab env false_lab;

	  cg_exp env e3;

	  fallthru();

	  emit_lab env end_lab

	end

    | P.Assign (e1,e2) -> 

	begin

	  cg_exp env e2;

	  cg_lhs_exp env e1 None;

	(*  let env' = push env T.Eax in

	  let dest = cg_lhs_exp env' e1 in

	  peek T.Ebx 0;

	  emit (T.Mov (dest,(T.Reg T.Ebx,[])));

	  pop T.Eax

*)

	end

    | P.AssignOp (e1,p,e2) ->

	begin	

	  cg_exp env e2;

	  cg_lhs_exp env e1 (Some p);

	  (* For now we load and then operate. *)

(*	  emit(T.Mov (T.Reg T.Eax, (dest,[])));

	  (match p with

	    (P.Plus | P.Times | P.Minus | P.Bitand | P.Bitor | P.Bitxor) ->

	      begin

		let op = 

		  (match p with

		    P.Plus -> T.Add

		  | P.Times -> T.Imul2

		  | P.Minus -> T.Sub

		  | P.Bitand -> T.And

		  | P.Bitor -> T.Or

		  | P.Bitxor -> T.Xor

		  | _ -> (raise (impos "This is exhaustive!!"))) in 

	      	peek T.Ebx 0;

	      	emit(T.ArithBin (op,T.Reg T.Eax,T.Reg T.Ebx));

	        (* register should already be in the right state!! *)

	      end

	  | (P.Bitlshift | P.Bitlrshift | P.Bitarshift) ->

	      begin

		let op = 

		  (match p with

		    P.Bitlshift -> T.Shl

		  | P.Bitlrshift -> T.Shr

		  | P.Bitarshift -> T.Sar

		  | _ -> (raise (impos "This is exhaustive"))) in

		peek T.Ecx 0;

		emit (T.ArithSR (op,T.Reg T.Eax, None));

		(* register should already be in right state. *)

	      end

	  | (P.Div | P.Mod ) -> 

	      begin

	      	let op = T.Idiv in

	      	peek T.Edx 0;

	      	emit(T.ArithMD (op,T.Reg T.Edx));

		match p with 

		  P.Mod -> emit(T.Mov (T.Reg T.Eax, (T.Reg T.Edx,[])))

	      	| P.Div -> ()

		| _ -> (raise (impos "This is exhaustive!"))

	      end

	  | _ -> (raise (impos "cg_exp: AssignOp no other operators possible.")));

	  emit(T.Mov (dest,(T.Reg T.Eax,[])));

	  pop T.Ebx

*)

  	end

    | P.FunCall (e,es) ->

	begin

	  let cg_arg env e = (cg_exp env e; push env T.Eax) in

	  let env' = List.fold_left cg_arg env (List.rev es) in

	  cg_exp env' e;

	  emit(T.Call (T.Reg T.Eax,[T.Tapp env.stack_type]));

	  let n = List.length es in

	  (pop_free n);

	  

	end

    | P.NewStruct(n,es) -> 

	begin

	  let s_info = try Dict.lookup env.type_info.structs n 

	  with Dict.Absent -> (raise (impos "cg_exp: unbound struct."))

	  in

	  let num_fields = (List.length es) in

	  let mallocarg = T.Mprod (List.map (fun (_,_,s) -> s) 

				     s_info.sfield_infos) in

	  let malloccon = ref (mallocarg2con mallocarg) in



	  let cg_field env e = (cg_exp env e; push env T.Eax ) in

	  let env' = (List.fold_left cg_field env (List.rev es)) in

	  (* Do the malloc *)

	  emit(T.Malloc (T.Ebx,4*num_fields,mallocarg));

	  let offset = ref 0 in

	  let store_field ()= 

	    pop T.Eax; 

	    emit(T.Mov (T.Prjr ((T.Ebx,[]),4 * !offset),(T.Reg T.Eax,[])));

	    incr offset

	  in 

	  while(!offset<num_fields) do store_field () done;

	  (if (s_info.struct_null)

	  then emit(T.Mov(T.Reg T.Eax,(T.Reg T.Ebx,[T.RollTosum(name_con n)])))

	  else emit(T.Mov(T.Reg T.Eax,(T.Reg T.Ebx,[T.Roll(name_con n)]))));

	  add_reg env T.Eax (name_con n)

	end

    | P.StructMember (e',n) ->

	begin

	  cg_exp env e';

	  let t = exp2typ e' in

	  let s_info = typ2struct_info env t in

	  let offset = struct_field_offset s_info n in

	  emit(T.Coerce(T.Eax,[T.Unroll]));

	  (if s_info.struct_null then check_not_null T.Eax);

	  emit(T.Mov (T.Reg T.Eax,(T.Prjr ((T.Eax,[]),4*offset),[])));

	  add_reg env T.Eax (exp2con env e)

	end

    | P.NewUnion (nt,f,eo) ->

	begin

	  let u_info = typ2union_info env (P.NamedType nt) in

	  try (match eo with

	    None -> (* void_case *)

	      begin

		let tag = List.assoc f u_info.void_infos in

		emit(T.Mov (T.Reg T.Eax, 

			    (T.Tag tag,[T.RollTosum (name_con nt)])));

	        (add_reg env T.Eax (name_con nt))

	      end

	  | Some(e') -> (* value_case *)

	      begin

		let (tag,con) = List.assoc f u_info.value_infos in

		let single_value_case = List.length u_info.value_infos=1 in

		cg_exp env e';

		(if single_value_case 

		then 

		  let mallocarg =  T.Mprod [con,T.Read] in

		  (emit(T.Malloc(T.Ebx,4,mallocarg));

		   emit(T.Mov (T.Prjr ((T.Ebx,[]),0),(T.Reg T.Eax,[])));

		   emit(T.Mov (T.Reg T.Eax,

			       (T.Reg T.Eax,[T.RollTosum (name_con nt)]))))

		else 

		  let tag_con = dc (T.Cprim (T.PCtag tag)) in

		  let mallocarg = T.Mprod [(tag_con,T.Read);(con,T.Read)] in 

		  (emit(T.Malloc(T.Ebx,8,mallocarg));

		   emit(T.Mov(T.Prjr ((T.Ebx,[]),4),(T.Reg T.Eax,[])));

		   emit(T.Mov(T.Prjr ((T.Ebx,[]),0),(T.Tag tag,[])));

		   emit(T.Mov(T.Reg T.Eax, 

			      (T.Reg T.Ebx,[T.RollTosum (name_con nt)]))))

		    );

		(add_reg env T.Eax (name_con nt))

	      end) 

	  with Not_found->(raise (impos "cg_exp: NewUnion: No such tag."))

	end

    | P.NewTuple es ->

	let num_fields = (List.length es) in

	let margs = List.map (fun e -> (exp2con env e,T.Read)) es in

	let mallocarg = T.Mprod margs in

	let c = 

	  T.defcon(T.Cprod(List.map (fun (c,cap) -> (c,cap,T.Init)) margs)) in

	let env' = List.fold_left (fun env e -> cg_exp env e; push env T.Eax)

	    env (List.rev es) in

	emit(T.Malloc (T.Eax,4*num_fields,mallocarg));

	for offset = 0 to num_fields - 1 do

	  pop T.Ebx;

	  emit(T.Mov (T.Prjr ((T.Eax,[]),4 * offset),(T.Reg T.Ebx,[])));

	done;

	add_reg env T.Eax c

    | P.TupleMember(e,i) ->

	(match exp2typ e with

	  P.TupleType ts ->

	    let result_t = typ2con env (List.nth ts (i - 1)) in

	    cg_exp env e;

	    emit(T.Mov (T.Reg T.Eax, (T.Prjr((T.Eax,[]),4*(i-1)),[])));

	    add_reg env T.Eax result_t

	| _ -> raise (impos "cg_exp: TupleMember: not tuple"))

    | P.Subscript (e1,e2) ->

	begin

	  cg_exp env e2;

	  let env' = push env T.Eax in

	  let scale = 

	    (match exp2typ e1 with

	      P.StringType -> T.Byte1

	    | _ -> T.Byte4) in

	  cg_exp env' e1;

	  pop T.Ebx;

	  emit(T.Asub (scale, T.Eax,T.Reg T.Eax, T.Ebx));

	  let eax_con = exp2con env e in

	  (add_reg env T.Eax (eax_con))

	end

    | P.NewArray(e1,e2) -> (* e1 is the size, e2 is the initializer. *)

	begin

	  cg_exp env e2;

	  let e2_con = 

	    try

	      (lookup_reg env T.Eax)

	    with Dict.Absent -> (raise (impos "cg_exp: NewArray"))

	  in

	  let env' = push env T.Eax in

	  cg_exp env' e1;

	  let env'' = push env' T.Eax in

	  emit(T.Call (T.Addr new_array_label,

		       [T.Tapp e2_con; T.Tapp env.stack_type]));

	  pop_free 2;

	  add_reg env T.Eax (array_con e2_con)

	end

    | P.Compile _ -> raise(unimpl "compile")

    | P.Hole _ -> raise(unimpl "hole")

  end

(* cg_lhs_exp: env -> exp -> P.op option -> unit.

   Compute the address of exp (if needed push Eax onto the stack)

   if Some op then push stuff for address onto stack if dynamic.

                   load the value

                   compute op

   Store EAX into address.

*)



and cg_lhs_exp env e op_opt=

  begin

    match e.P.raw_exp with

      P.Var x -> 

	begin

	  let gop = 

	    try 

              let (con,offset) = List.assoc x env.local_env in

	      (T.Prjr ((T.Esp,[]),4*offset))

	    with Not_found -> 

	      begin

	      	try 

	      	  (T.Addr (pid2tid x))

	      	with Dict.Absent -> (raise (impos "cg_exp: Var without type."))

	      end in

	  (match op_opt with

	    None -> ()

	  | Some op ->

	      let env' = push env T.Eax in

	      cg_exp env' e;

	      let _ = cg_bop env' op TopStack in

	      ()

	   );   

	  emit(T.Mov (gop,(T.Reg T.Eax,[])));

	end

    | P.StructMember (e,f) ->

	begin

	  let env' = push env T.Eax in

	  cg_exp env' e;

	  let struct_info = typ2struct_info env (exp2typ e) in

	  let gop r =

	    let offset = struct_field_offset struct_info f in

	    (T.Prjr ((r,[]),4*offset))

	  in

	  (match op_opt with

	    None -> (pop T.Ebx;

		     emit(T.Coerce(T.Eax,[T.Unroll]));

		     (if(struct_info.struct_null) then check_not_null T.Eax);

		     emit(T.Mov (gop T.Eax,(T.Reg T.Ebx,[]))))

	  | Some op ->

	      begin

		let env'' = push env' T.Eax in (* Eax has address of struct.*)

		emit (T.Coerce (T.Eax,[T.Unroll]));

		(if struct_info.struct_null then check_not_null T.Eax);

		emit (T.Mov (T.Reg T.Eax, (gop T.Eax,[])));

		cg_bop env'' op (Stack 1);

		pop T.Ebx; (* EBX = address of struct. EAX = value *)

		(* XXX - I don't think the following check is necessary,

		   but for now... *)

		(if struct_info.struct_null then check_not_null T.Ebx);

		emit (T.Coerce (T.Ebx,[T.Unroll]));

		emit (T.Mov (gop T.Ebx,(T.Reg T.Eax,[])));

		pop_free 1 (* Free value we pushed originally. *)

	      end

	  	)

	end

    | P.Subscript (e1,e2) ->

	begin

	  let env' = push env T.Eax in 

	  cg_exp env' e2;

	  let env'' = push env' T.Eax in

	  cg_exp env'' e1;

	  (* Eax = address of array; Stack = offset,value *)

	  match op_opt with

	    None ->

	      begin

		emit(T.Mov (T.Reg T.Ecx,(T.Reg T.Eax,[])));

		pop T.Ebx;

		pop T.Eax;

		emit(T.Aupd (T.Byte4,T.Reg T.Ecx,T.Ebx,T.Eax))		

	      end

	  | Some op ->

	      begin

		let env_op = push env'' T.Eax in

		peek T.Ebx 1; (* subscript *)

		emit(T.Asub (T.Byte4,T.Eax,T.Reg T.Eax, T.Ebx));

		cg_bop env_op op (Stack 2);

		pop T.Ecx; (* Address of array *)

		pop T.Ebx; (* subscript *)

          	emit(T.Aupd (T.Byte4,T.Reg T.Ecx,T.Ebx,T.Eax));

		pop_free 1;

	      end

	end

    | _ -> (raise (impos "cg_lhs_exp: Not allowed by type-checker."))

  	end

(* cg_stmt env -> P.stmt -> bool *)

(* bool = true if stmt returns, false otherwise. *)

let rec cg_stmt env (s,loc) = 

  begin

    match s with

      P.Skip -> false

    | P.Exp e -> (cg_exp env e; false)

    | P.Seq (s1,s2) -> (cg_stmt env s1 or cg_stmt env s2)

    | P.Return eopt ->

      	begin

	  (match eopt with

	    None -> ()

	  | Some e -> cg_exp env e; ());

	(* pop local variables from stack*)

	  let n = (List.length env.local_env) - env.args_on_stack in

	  pop_free n;

	  emit(T.Retn None); 

	  true

      	end

    | P.IfThenElse(e,s1,s2) ->

      	begin

      	  let false_lab = Id.id_new "iffalse" in

      	  let end_lab = Id.id_new "ifend" in

	  cg_exp env e;

	  emit (T.Btagi(T.Eax,0,(false_lab,branch_coercion),T.Eq));

	  let s1_returns = cg_stmt env s1 in

	  (if not s1_returns

	  then emit (T.Jmp(T.Addr end_lab,branch_coercion)));

	  env.regs <- empty_regs;

	  emit_lab env false_lab;

	  let s2_returns = cg_stmt env s2 in

	  if not s2_returns

	  then fallthru();

	  env.regs <- empty_regs;

	  if not (s1_returns & s2_returns)

	  then (emit_lab env end_lab; false)

	  else true

      	end

    | P.While(e,s) ->

      	begin

	  let loopbody = Id.id_new "whilebody" in

          let looptest = Id.id_new "whiletest" in

	  let loopend = Id.id_new "whileend" in

	  let env' = set_loop_labels env loopend looptest in

	  emit(T.Jmp(T.Addr looptest,branch_coercion));

	  env'.regs <- empty_regs;

	  emit_lab env' loopbody;

	  (if(not (cg_stmt env' s)) then fallthru());

	  env'.regs <- empty_regs;

	  emit_lab env' looptest;

	  cg_exp env' e;

	  emit (T.Btagi(T.Eax,1,(loopbody,branch_coercion),T.Eq));

	  fallthru();

	  env'.regs <- empty_regs;

	  emit_lab env' loopend;

	  false

      	end

    | P.Break -> 

      	(match env.break_label with

	  None -> (raise (impos "cg_stmt: missing break label"))

      	| Some (l,n) -> 

	    begin

	      let d = (List.length env.local_env) - n in

	      pop_free d;

	      emit(T.Jmp(T.Addr l,branch_coercion));

	      false

	    end)

    | P.Continue ->

      	begin

	  match env.continue_label with

	    None -> (raise (impos "cg_stmt: missing continue label"))

      	  | Some (l,n) -> 

	      begin

	      	let d = (List.length env.local_env) - n in

	      	pop_free d;

	      	emit(T.Jmp(T.Addr l,branch_coercion));

		true

	      end

	end

    | P.For(e1,e2,e3,s) ->

      	begin

	  let looptest = Id.id_new "fortest" in

	  let loopbody = Id.id_new "forbody" in

	  let loopcount = Id.id_new "forcount" in

	  let loopend = Id.id_new "forend" in

	  let env' = set_loop_labels env loopend loopcount in

	  cg_exp env e1;

	  emit(T.Jmp(T.Addr looptest,branch_coercion));

	  env'.regs <- empty_regs;

	  emit_lab env' loopbody;

	  let s_returns = (cg_stmt env' s) in

	  (if (not s_returns) then fallthru());

	  env'.regs <- empty_regs;

	  emit_lab env' loopcount;

	  cg_exp env' e3;

	  fallthru();

	  env'.regs <- empty_regs;

	  emit_lab env' looptest;

	  cg_exp env' e2;  

	  emit (T.Btagi(T.Eax,1,(loopbody,branch_coercion),T.Eq));

	  fallthru();

	  env'.regs <- empty_regs;

	  emit_lab env' loopend;

	  false

     	end

    | P.CharSwitch(e,ss,s) -> 

      (* compiler character switches as integer switches *)

	let raw_e' = (P.Primop(P.Ord,[e])) in

	let e' = { P.exp_typ = Some P.IntType; 

		   P.raw_exp = raw_e'; 

		   P.exp_loc = e.P.exp_loc

		 } in

	let (ss',s') = List.map (fun (c,s) -> (Char.code c,s)) ss,s in

      	cg_stmt env (P.IntSwitch(e', ss', s'),loc)

    | P.IntSwitch(e,ss,s) ->

      (* just do iterated ifs -- later we can do something smart. *)

      	begin

      	  cg_exp env e;

	  let env_empty = copy_env env in

	  let env2 = copy_env env in

	  env_empty.regs <- empty_regs;

      	  let end_label = Id.id_new "endswitch" in

      	  let rec aux r l arms returns = 

	    (match arms with

	      [] -> 

	      	begin

	      	  let s_returns = cg_stmt env s in

	      	  fallthru();

	      	  (if not (s_returns & returns)  

                  then (emit_lab env_empty end_label;false)

		  else true)

	      	end

	    | (i,s)::rest -> 

	      	begin

	      	  let l' = Id.id_new ("l" ^ (string_of_int i)) in

	      	  emit(T.Test(T.Reg r,T.Immed i));

	      	  emit(T.Jcc(T.NotEq,(l',branch_coercion)));

	      	  let s_returns = cg_stmt env_empty s in

	      	  (if not s_returns

                   then emit(T.Jmp(T.Addr end_label,branch_coercion)));

	      	  emit_lab env2 l';

	      	  aux r l' rest (s_returns & returns)

	      	end) in

	  (aux T.Eax (Id.id_new "never_used") ss true)

      	end

    | P.UnionSwitch(e,ss,d) ->

	begin

	  cg_exp env e;

	  let r = T.Eax in

      	  let u_info = typ2union_info env (exp2typ e) in

     	  let void_infos = u_info.void_infos in

	  let value_infos = u_info.value_infos in

	  let end_label = Id.id_new "endswitch" in

      	  let default_label = Id.id_new "default" in

      	  let cg_default d = 

	    (match d with

	      None -> true

	    | Some s -> 

	      	begin

		  env.regs <- empty_regs;

	      	  emit_lab env default_label; 

	      	  (if not (cg_stmt env s)

	      	  then (fallthru(); false)

		  else true)

	      	end) in

      	  let cg_void_case (tag,lab,s) = 

	    begin

	      env.regs <- empty_regs;

	      emit_lab env lab; 

	      (if not (cg_stmt env s)

	      then (emit(T.Jmp(T.Addr end_label,branch_coercion)); false)

	      else true)

	    end in

	  let cg_void_branch (tag,lab,s) =

	    begin

	      emit(T.Btagi(r,tag,(lab,branch_coercion),T.Eq));

	    end in

      	  let cg_value_case (tag,con,lab,x,s) = 

	    let svt = T.Variants[(tag,[(con,T.Read,T.Init)])] in

	    begin

	      add_reg env r (dc (T.Csum{T.sum_tags=[];T.sum_vt=Some(svt)}));

	      emit_lab env lab;

	      emit(T.Mov(T.Reg T.Eax,(T.Prjr((r,[T.Fromsum]),4),[])));

	      emit(T.Push(T.Reg T.Eax,[]));

	      let s_returns = cg_stmt (add_local_var x con env) s in

	      if not s_returns 

	      then (pop_free 1;

		    emit(T.Jmp (T.Addr end_label,branch_coercion)); 

		    false)

	      else true

	    end in

	  let cg_value_branch (tag,con,lab,x,s) =

	    begin

	      emit(T.Btagvar(r,tag,(lab,branch_coercion),T.Eq))

	    end in

    	  let rec split cs value_cs void_cs= 

	    (match cs with

	      [] -> (List.rev value_cs, List.rev void_cs)

	    | ((f,Some(x),s) :: tl) -> 

		begin

		  let lab = Id.id_new (f ^ "_value") in

		  let (tag,con) = 

		    try List.assoc f value_infos

		    with Not_found -> (raise (impos ("cg_exp: Unionswitch: Value case without tag."))) 

		  in

		  split tl ((tag,con,lab,x,s)::value_cs) void_cs

		end

	    | ((f,None,s) :: tl) ->

		begin

		  let lab = Id.id_new (f ^ "_void") in

		  let tag = 

		    try List.assoc f void_infos 

		    with Not_found -> (raise (impos ("cg_exp: UnionSwitch: Void case without tag.")))

		  in

		  split tl value_cs ((tag,lab,s) :: void_cs)

		end)

	  in

	  let (value_cases,void_cases) = split ss [] [] in

	  let value_cases = (Sort.list 

			     (fun (tag1,_,_,_,_) (tag2,_,_,_,_)->(tag1>tag2))

			     value_cases)

	  in

	  let void_cases = (Sort.list (fun (tag1,_,_) (tag2,_,_)->(tag1>tag2))

			      void_cases)

	  in

	  let cg_default_void_case tag = 

	    emit (T.Btagi(T.Eax,tag,(default_label,branch_coercion),T.Below))

	  in

	  let voids_exhaustive = (List.length void_cases =

				  List.length void_infos) in

	  let values_exhaustive = (List.length value_cases = 

				   List.length value_infos) in

	  let cg_value_branches vc = 

	    begin

	      match (voids_exhaustive,List.rev vc) with

		(false,hd::tl) -> 

		  begin

		    let (tag,_,_,_,_) = hd in

		    cg_default_void_case tag;

		    List.iter cg_value_branch vc;

		  end

	      |	_ -> (List.iter cg_value_branch vc)

	    end in

	  emit(T.Coerce(r,[T.Unroll]));

      	  (match d with

	    Some s ->

	      begin

	  	List.iter cg_void_branch void_cases;

		cg_value_branches value_cases ;

		emit (T.Jmp (T.Addr default_label,branch_coercion))

	      end

	  | None -> 

	      begin

		match value_cases with

		  [] ->

		    begin

		      match void_cases with

			[] -> (raise (impos "...."))

		      |	(hd::tl) ->

			  begin

			    List.iter cg_void_branch tl;

			    fallthru();

			  end



		    end

		| hd::tl ->

		    begin

		      List.iter cg_void_branch void_cases;

		      List.iter cg_value_branch tl;

		      fallthru();

		    end

	      end

		);

	  let values_return = (List.for_all (fun x -> x)

	      (List.map cg_value_case value_cases)) in

	  let voids_return = (List.for_all (fun x -> x) 

	      (List.map cg_void_case void_cases)) in

	  let default_returns = (cg_default d) in

	  if not (voids_return & (values_return & default_returns)) 

	  then

	    (env.regs <- empty_regs;

	    emit_lab env end_label;

	    false)

	  else true  

	end

    | P.Decl(x,t,roe,s) ->

      	begin

	  let e = 

	    (match !roe with

	      None -> (raise (impos "cg_stmt : decl - None"))

	    | Some e -> e)

	  in

	  cg_exp env e;

	  emit(T.Push (T.Reg T.Eax,[]));

	  if not (cg_stmt (add_local_var x (typ2con env t) env) s)

	  then (pop_free 1; false)

	  else true

      	end

    | P.Do(s,e) ->

        begin

          let loopstart = Id.id_new "loopstart" in

          let looptest = Id.id_new "looptest" in

          let loopend = Id.id_new "loopend" in

          fallthru();

          let env' = set_loop_labels env loopend loopstart in

	  env'.regs <- empty_regs;

          emit_lab env' loopstart;

	  let s_returns = (cg_stmt env' s) in

	  (if (not s_returns) then fallthru());

	  env'.regs <- empty_regs;

          emit_lab env' looptest;

          cg_exp env' e;

	  emit (T.Btagi(T.Eax,1,(loopstart,branch_coercion),T.Eq));

	  fallthru();

	  env'.regs <- empty_regs;

          emit_lab env' loopend;

          false

        end

    | P.Suspend _ -> raise(unimpl "suspend")

    | P.Resume _ -> raise(unimpl "resume")

  end (* cg_stmt *)

 

(* info_structdecl: env -> P.structdecl -> struct_info *)

let info_structdecl env st =

  begin

    let scope = st.P.st_scope in

    let name = st.P.st_name in

    let null = st.P.st_possibly_null in

    let fields = st.P.st_fields in

    let offset = ref 0 in

    let post_incr  i = (let j = !i in i:=j+1;j) in

    let info_field sf =

      begin

	let (n,cap,t) = sf in

	(n,post_incr offset, 

	 (typ2con env t,

	  (match cap with

	     P.ReadOnly ->  T.Read

	   | P.ReadWrite -> T.ReadWrite)

	 ))

      end in

    let field_infos = List.map info_field fields in

    let struct_con' = List.map (fun (n,offset,(con,cap))->(con,cap,T.Init))

 	              field_infos in

    let struct_con = 

      if null 

      then dc (T.Csum {T.sum_tags=[0]; 

			T.sum_vt = Some(T.Tuple struct_con')

		      })  

      else dc (T.Cprod struct_con') 

    in

     { sfield_infos = field_infos;

       struct_null = null;

       struct_con = struct_con

     }

  end;;

(* info_uniondecl: env -> P.uniondecl -> union_info *)  

let info_uniondecl env ud =

  begin

    let union_fields = ud.P.un_fields in

    let void_fields = ref [] in

    let value_fields = ref [] in

    let rec sort_fields fields =

      (match fields with

	[] -> ()

      |	((f,t) :: tl) -> 

	  begin

	    (match t with 

	      P.VoidType -> (void_fields := (f,t) :: !void_fields )

	    | _ -> (value_fields := (f,t) :: !value_fields));

	    sort_fields tl

	  end); in

    sort_fields union_fields;

    let (void_fields,value_fields) =  (List.rev !void_fields,

				       List.rev !value_fields) in

    let i = ref 1 in

    let post_incr i = (let j = !i in  i:=j+1;j) in

    let void_info (n,t) = (n,post_incr i) in

    let value_info (n,t) = (n,(post_incr i, typ2con env t)) in

    let void_infos = List.map void_info void_fields in

    let value_infos = 

      (try

	List.map value_info value_fields

      with Void_Type -> (raise (impos "info_uniondecl: void_type"))) in

    let void_infos' =

      if ud.P.un_possibly_null

      then 

	("$null", 0) :: void_infos

      else

	void_infos

    in

    let tags = List.map (fun (n,i) -> i) void_infos' in

    let sum = 

      match value_infos with

	[] -> { T.sum_tags = tags; 

		T.sum_vt = None

	      }

      | [(n,(tag,con))] -> 

	  { T.sum_tags = tags; 

	    T.sum_vt = Some(T.Tuple [con2field con])

	  }	

      | _ ->

	  begin

	    let vars = List.map (fun (n,(tag,con)) -> 

	      (tag,[con2field con])) value_infos

	    in

	    { T.sum_tags = tags; 

	      T.sum_vt = Some(T.Variants vars)

	    } 

	  end

    in

    { void_infos = void_infos';

      value_infos = value_infos;

      union_con = dc (T.Csum sum);

      union_null= ud.P.un_possibly_null

    } 	

  end

    

(* cg_typedecl : env -> P.topdecl -> (env * (T.con_block list)) *)

let cg_typedecl (env : env) (td : P.top_decl) = 

  begin

    let (raw_td,loc) = td in

    let unions = ref env.type_info.unions in

    let structs = ref env.type_info.structs in

    let con_block : T.con_block list = 

      begin

      	match raw_td with

          P.StructDecl sd ->

	    begin

	      let null = sd.P.st_possibly_null in

	      let scope = sd.P.st_scope in

	      let name = sd.P.st_name in

	      let  s_info = info_structdecl env sd in

	      structs:= Dict.insert !structs name s_info;

	      let con = s_info.struct_con in

	      io_namedtype name scope null con 

	    end

      	| P.UnionDecl ud ->  (* This is busted!!! *)

	    begin

	      let name = ud.P.un_name in

	      let scope = ud.P.un_scope in

	      let null = ud.P.un_possibly_null in

	      let u_info = info_uniondecl env ud in

	      let con = u_info.union_con in

	      unions := Dict.insert !unions name u_info;

	      io_namedtype name scope null con 

	    end

      	| P.ExternType (tn,b) -> (* ?? *)

	    begin

	      let tn_label = name tn in

	      import_cons := (tn_label,T.K4byte,T.AbsCon) :: !import_cons;

	      begin

		(if b then

		  import_vals := (((null_name tn), name_con tn) 

				  :: !import_vals))

	      end;

	      []

	    end

	| P.ExternFun (ret_typ,n,params) ->

	    begin

	      let (con,_) = fun_con env ret_typ params in

	      import_vals := (pid2tid n,con) :: !import_vals;

	      []

	    end

      	| _ -> (raise (impos "cg_typedecl:!!!"))

      end in

    ({ global_env = env.global_env; 

       local_env = env.local_env; 

       args_on_stack = env.args_on_stack;

       stack_type = env.stack_type;

       break_label = env.break_label;

       continue_label = env.continue_label;

       type_info = { unions = !unions; structs = !structs};

       regs = env.regs

     },

     con_block)

  end



let cg_fundecl env fd =

  begin

    let name = fd.P.fn_name in

    let ret_typ = fd.P.fn_ret_type in

    let args = fd.P.fn_args in

    let body = fd.P.fn_body in

    let params = List.map (fun (x,t) -> t) args in

    let (con,stack_type) = fun_con env ret_typ params in

    let lab = if name = main_id then main_label else (pid2tid name) in

    (if fd.P.fn_static 

    then export_vals := ((lab,con) :: !export_vals));

    current_label := (lab,con);

    let depth = ref 0 in

    let aux (x,t) = (x,(typ2con env t, (incr depth; !depth))) in

    let local_env = List.map aux args in

    let env' = 

      { global_env = env.global_env;

	local_env = List.rev local_env;

	args_on_stack = List.length local_env;

	stack_type = stack_type;

	break_label = None;

	continue_label = None;

	type_info = env.type_info;

	regs = empty_regs

      } in

    (if (not (cg_stmt env' body)) then emit(T.Retn None));

    flush_code();

    if (name = main_id) then true else false 

  end



(* cg_all : env -> P.top_decl list -> T.tal_imp *)

(* Sort the top decls, Generate the type decls, Generate the functions,

   build the tal_imp structure. *)

let cg_all env topdecls = 

  begin

    let type_decls = ref []  in

    let fun_decls = ref [] in

    let rec sort_decls ds = 

      begin

	match ds with

	  [] -> ()

	| ((P.FunDecl fd,_) :: tl) -> (fun_decls := fd :: !fun_decls; 

				     sort_decls tl)

	| ( hd :: tl) -> (type_decls := hd :: !type_decls; 

			  sort_decls tl)

      end in

    sort_decls topdecls;

    let type_decls = !type_decls in

    let fun_decls = !fun_decls in

    reset_generator ();

    let aux td (env,cbl) = (let (env',cbl') = cg_typedecl env td in

                            (env',cbl'@ cbl)) 

    in

    let (env',con_blocks) = List.fold_right aux type_decls (env,[]) in

    let has_main = (List.map (cg_fundecl env') fun_decls) in

    let has_main = List.exists (fun x -> x) has_main in

    (if has_main then

      code_blocks := tal_main_code_block :: !code_blocks);

    (con_blocks,has_main)

  end



let code_gen mod_name import_file export_file (td,global_env) =

  begin

    let env = { global_env = global_env;

		local_env = [];

		args_on_stack = 0;

		stack_type = tal_main_con;

		break_label = None;

		continue_label = None;

		type_info = { unions=Dict.empty compare; 

			      structs=Dict.empty compare 

			    };

		regs = empty_regs

	      }	in

    let (con_blocks,has_main) = cg_all env td in

    let implementation =     

      { T.imports = [| "tal.tali"; "pop_runtime.tali"; import_file |];

(*T.imports = [|"tal.tali";"stdlib.tali";import_file|];*)

      	T.exports = if has_main 

	then [|"tal_prog.tali"; export_file|]

	else [|export_file|];

      	T.con_blocks = Array.of_list (default_con_blocks @ con_blocks);

      	T.code_blocks = Array.of_list (List.rev !code_blocks);

      	T.data_blocks = Array.of_list !data_blocks

    } in

    let export_interface = 

      { T.int_includes = [||];

	T.int_cons = (Array.of_list !export_cons);

	T.int_vals = (Array.of_list !export_vals)

      }	in

    let import_interface = 

      { T.int_includes = [||];

	T.int_cons = (Array.of_list !import_cons);

	T.int_vals = (Array.of_list (default_import_vals @ !import_vals))

      }	in

    (implementation,import_interface,export_interface)

  end

















