#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

void *GC_malloc(int size);

typedef struct {int size; char chars[1];} *string;

void print_int(int x)
{
  printf("%d",x);
  return;
}

void print_string(string s)
{
  fwrite(s->chars, 1, s->size, stdout);
}

void print_newline(void)
{
  putchar('\n');
}

int int_of_string(string s)
{
  int n, i, sign=1;
  for(i=0; i<s->size && isspace(s->chars[i]); i++);
  while (i<s->size &&(s->chars[i]=='-' || s->chars[i]=='+')) {
    if (s->chars[i]=='-') sign=-sign;
    i++;
  }
  if (i==s->size) {
    fprintf(stderr, "\ninvalid string to integer conversion\n");
    exit(2);
  }
  for(n=0; i<s->size; i++) {
    char c=s->chars[i];
    if ('0'<=c && c<='9')
      n=n*10+(int)(c-'0');
    else {
      fprintf(stderr, "\ninvalid string to integer conversion\n");
      exit(2);
    }
  }
  return sign*n;
}

string string_of_int(int n)
{
  string str=GC_malloc(16);
  sprintf(str->chars, "%d", n);
  str->size=strlen(str->chars);
  return str;
}

typedef struct {int size; void *elms[1];} *array;

array new_array(int size, void *init)
{
  array na=GC_malloc(4+size*4);
  na->size=size;
  while(size-->0)
    na->elms[size]=init;
  return na;
}

/* EOF: stdlib.c */
