(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew, Chris Hawblitzel,                   *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

open Popast;;

type typ_env = (string * typ) list

type typed_exp = typ_env * typ * tc_exp
and tc_exp =
    TcIntop of int_op * typed_exp * typed_exp
  | TcCompare of compare * typed_exp * typed_exp
  | TcNull of string
  | TcNot of typed_exp
  | TcIf of typed_exp * typed_exp * typed_exp
  | TcWhile of typed_exp * typed_exp
  | TcCompound of typed_exp * typed_exp
  | TcLet of tc_let_decl * typed_exp
  | TcVarExp of string
  | TcAssign of string * typed_exp
  | TcConstInt of int
  | TcConstBoolean of bool
  | TcConstString of string
  | TcConstVoid
  | TcConstArray of typed_exp list
  | TcPrintInt of typed_exp
  | TcPrintString of typed_exp
  | TcPrintNewline 
  | TcIntOfString of typed_exp
  | TcStringOfInt of typed_exp
  | TcStdArgs
  | TcFunCall of string * (typed_exp list)
  | TcReturn of typed_exp
  | TcNewStruct of string * (typed_exp list)
  | TcStructMember of typed_exp * string
  | TcAssignStructMember of typed_exp * string * typed_exp
  | TcSubscript of typed_exp * typed_exp
  | TcNewArray of typed_exp * typed_exp
  | TcArraySize of typed_exp
  | TcArrayAssign of typed_exp * typed_exp * typed_exp
and tc_let_decl =
    TcVarDecl of string * typ * typed_exp

type tc_func_decl = typ * (decl list)
type tc_struct_decl = bool * Popast.struct_type * decl list

type tc_env = {
    env_fun : (string * tc_func_decl) list;
    env_tids : string list;
    env_sdefs : (string * tc_struct_decl) list
  }
;;

type tc_extern_decl =
    TcExternFun of typ * string * typ list
  | TcExternStruct of string

type tc_top_decl =
    TcFunDecl of bool * string * tc_func_decl * typed_exp

exception TypeError of string
exception NotImplemented of string
exception DeclaredTwice of string
exception MustReturnValue of string
exception RequiresMainFunction of string
exception NoSuchFunction of string
exception NoSuchStruct of string
exception NoSuchVariable of string
exception NoSuchField of string

val typecheck :
  ast ->
    tc_env * tc_extern_decl list * tc_top_decl list
