(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew, Chris Hawblitzel,                   *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

type typ =
    VoidType
  | IntType
  | BooleanType
  | StringType
  | ArrayType of typ
  | StructType of string

type typ_list =
    NilTypes
  | TypesLeft of typ_list * typ

type exp =
    Intop of Popast.int_op * exp * exp
  | Compare of Popast.compare * exp * exp
  | Null of string
  | Not of exp
  | Conditional of exp * exp * exp
  | VarExp of string
  | Assign of string * exp    (* this should really be exp * exp *)
  | ConstInt of int
  | ConstBoolean of bool
  | ConstString of string
  | ConstArray of exp_list * typ option
  | PrintInt of exp
  | PrintString of exp
  | PrintNewline 
  | IntOfString of exp
  | StringOfInt of exp
  | StdArgs
  | FunCall of string * exp_list
  | NewStruct of string * exp_list
  | StructMember of exp * string
  | AssignStructMember of exp * string * exp
  | Subscript of exp * exp
  | NewArray of exp * exp
  | ArraySize of exp
  | ArrayAssign of exp * exp * exp
and exp_list =
    NilExps
  | ExpsLeft of exp_list * exp
  | ExpsRight of exp * exp_list

type var_decls =
    VarDecl of string * exp
  | VarDecls of var_decls * var_decls

type stmt =
    Block of stmt
  | IfThen of exp * stmt
  | IfThenElse of exp * stmt * stmt
  | While of exp * stmt
  | Compound of stmt * stmt
  | LocalDecl of typ * var_decls
  | ExpStmt of exp
  | Return of exp
  | ReturnVoid
  | EmptyStmt

type decl = Decl of string * typ

type decls =
    NilDecls
  | DeclsLeft of decls * decl
  | DeclsRight of decl * decls

type top_decl =
    FunDecl of (bool * string * typ * decls * stmt)
  | StructDecl of (bool * string * Popast.struct_type * decls)
  | ExternFun of typ * string * typ_list
  | ExternStruct of string
  | TopDecls of top_decl * top_decl

type syntax = Syntax of top_decl

val syntaxToAst : syntax -> Popast.ast
