(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew, Chris Hawblitzel,                   *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

{
open Popparse;;

let rw = Hashtbl.create 101;;
List.iter (fun (s,t) -> Hashtbl.add rw s t)
    [ "boolean",BOOLEAN; "else",ELSE; "extern",EXTERN;
      "false",CONSTBOOLEAN false;
      "for",FOR; "if",IF; "int",INT; "intOfString",INTOFSTRING;
      "new",NEW; "newarray",NEWARRAY; "null",NULL; "printInt",PRINTINT;
      "printNewline",PRINTNEWLINE; "printString",PRINTSTRING;
      "return",RETURN; "size",SIZE; "static",STATIC; "stdargs",STDARGS;
      "string",STRING;
      "stringOfInt",STRINGOFINT; "struct",STRUCT;
      "true",CONSTBOOLEAN true; "void",VOID; "while",WHILE
    ]
;;

let process_id s =
  try Hashtbl.find rw s with Not_found -> ID s
;;

exception Unterminated_String;;
exception Bad_String_Character;;

let string_buffer = ref (String.create 100) ;;
let string_size = ref 100;;
let string_pos = ref 0;;
let store_string_char char =
  begin
    if !string_pos >= !string_size then
      let str = String.create(2 * (!string_size))
      in
         begin
	   String.blit !string_buffer 0 str 0 !string_size;
	   string_buffer := str;
	   string_size := 2 * !string_size
	 end
    else ();
    String.set !string_buffer !string_pos char;
    string_pos := 1 + !string_pos
  end
;;

let get_stored_string () = 
  let str = String.sub !string_buffer 0 !string_pos
  in (string_pos := 0; str)
;;

}

rule token = parse
  ['A'-'Z''a'-'z']['A'-'Z''a'-'z''0'-'9''_']*
                                  { process_id (Lexing.lexeme lexbuf) }
| ['0'-'9']+  
                                  { CONSTINT
				      (int_of_string (Lexing.lexeme lexbuf)) }
| "("             		  { LPAREN }
| ")"             		  { RPAREN }
| "{"             		  { LBRACE }
| "}"             		  { RBRACE }
| "["             		  { LBRACKET }
| "]"             		  { RBRACKET }
| "+"             		  { PLUS }
| "-"             		  { MINUS }
| "*"             		  { TIMES }
| "/"             		  { DIV }
| "=="            		  { EE }
| "!="            		  { NE }
| "="             		  { EQUALS }
| "!"             		  { BANG }
| "?"             		  { QUESTION }
| ":"             		  { COLON }
| ";"             		  { SEMICOLON }
| "."             		  { DOT }
| ","             		  { COMMA }
| "<="            		  { LESSTHANEQ }
| ">="            		  { GREATERTHANEQ }
| "<"             		  { LESSTHAN }
| ">"             		  { GREATERTHAN }
| "++"            		  { PLUSPLUS }
| "--"            		  { MINUSMINUS }
| "+="            		  { PLUSEQUAL }
| "-="            		  { MINUSEQUAL }
| "*="            		  { TIMESEQUAL }
| "/="            		  { DIVEQUAL }
| "&&"            		  { AMPERAMPER }
| "||"            		  { PIPEPIPE }  
| [' ' '\n' '\t']+                { token lexbuf }
| "//"[^'\n']*'\n'                { token lexbuf }
| "/*"([^'*']|'*'[^'/'])*'*'?"*/" { token lexbuf }
| "\""
    { string_pos := 0; string lexbuf; CONSTSTRING(get_stored_string()) }
| eof                           { EOF }
and string = parse
    "\""            { () }
  | "\\\n"          { string lexbuf }
  | "\\\t"          { string lexbuf }
  | "\\ "           { string lexbuf }
  | "\\\\"          { store_string_char '\\'; string lexbuf }
  | "\\n"           { store_string_char '\n'; string lexbuf }
  | "\\t"           { store_string_char '\t'; string lexbuf }
  | "\\\""          { store_string_char '\034'; string lexbuf }
  | [' '-'~']       { store_string_char (Lexing.lexeme_char lexbuf 0);
		      string lexbuf }
  | eof             { raise Unterminated_String }
  | _               { raise Bad_String_Character }
