(**********************************************************************)
(* (c) Greg Morrisett, Neal Glew, Chris Hawblitzel,                   *)
(*     June 1998, all rights reserved.                                *)
(**********************************************************************)

(* pointers to Structs can be declared NeverNull (default) or
 * OptionNull.
 *)
type struct_type = NeverNull | OptionNull

type typ =
    VoidType
  | IntType
  | BooleanType
  | StringType
  | ArrayType of typ
  | StructType of string

type compare = IEq | INe | IGe | IGt | ILt | ILe

type int_op = Iplus | Itimes | Iminus | Idiv

type exp =
    Intop of int_op * exp * exp
  | Compare of compare * exp * exp
  | Null of string
  | Not of exp
  | If of exp * exp * exp
  | While of exp * exp
  | Compound of exp * exp
  | Let of let_decl * exp
  | VarExp of string
  | Assign of string * exp    (* this should really be exp * exp *)
  | ConstInt of int
  | ConstBoolean of bool
  | ConstString of string
  | ConstVoid
  | ConstArray of exp list * typ option
  | PrintInt of exp
  | PrintString of exp
  | PrintNewline 
  | IntOfString of exp
  | StringOfInt of exp
  | StdArgs
  | FunCall of string * (exp list)
  | Return of exp
  | NewStruct of string * (exp list)
  | StructMember of exp * string
  | AssignStructMember of exp * string * exp
  | Subscript of exp * exp
  | NewArray of exp * exp
  | ArraySize of exp
  | ArrayAssign of exp * exp * exp
and let_decl =
    VarDecl of string * typ * exp

type decl = Decl of string * typ

type top_decl =
    FunDecl of (bool * string * typ * (decl list) * exp)
  | StructDecl of (bool * string * struct_type * (decl list))
  | ExternFun of typ * string * typ list
  | ExternStruct of string


type ast = Ast of (top_decl list)

