/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*             Damien Doligez, projet Para, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: minor_gc.h,v 1.9 1997/09/02 12:54:05 xleroy Exp $ */

#ifndef _minor_gc_
#define _minor_gc_


#include "misc.h"

extern TLS char *young_start, *young_ptr, *young_end, *young_limit;
extern TLS value **ref_table_ptr, **ref_table_limit;
extern TLS asize_t minor_heap_size;
extern TLS int in_minor_collection;
extern TLS value **ref_table;

#define Is_young(val) \
  ((addr)(val) > (addr)young_start && (addr)(val) < (addr)young_end)

extern void set_minor_heap_size (asize_t);
extern void minor_collection (void);
extern void garbage_collection (void); /* for the native-code system */
extern void realloc_ref_table (void);
extern void oldify (value, value *);

#endif /* _minor_gc_ */
