/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*         Xavier Leroy and Damien Doligez, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: main.c,v 1.23 1997/11/17 15:11:56 doligez Exp $ */

/* Main entry point (can be overriden by a user-provided main()
   function that calls caml_main() later. */

#include "multithreads.h"

#include <stdio.h>

#include "misc.h"
#include "mlvalues.h"
#include "sys.h"

extern void caml_main (char **);

#ifdef _WIN32
extern void expand_command_line (int *, char ***);
#endif

#if macintosh
#include "rotatecursor.h"
#include "signals.h"
int volatile have_to_interact = 0;
#endif

int current_token;
BOOL mt_option = FALSE;

void extract_commandLine(char **argv, char **buf)
{
	int current_buf = 0;
	int len = strlen(argv[current_token]);
	strncpy(buf[current_buf], argv[current_token], len);
	// terminate string
	buf[current_buf][len] = 0;
	// move to next token
	current_token++;

	__try
	{
		// contain special keywords that use during building code up
		if ( (_stricmp(buf[current_buf], "ocamlc") == 0) || 
			(_stricmp(buf[current_buf], "ocamlc.exe") == 0) || 
			(_stricmp(buf[current_buf], "boot\\ocamlc") == 0) ||
			(_stricmp(buf[current_buf], "boot\\ocamlc.exe") == 0) ||
			(_stricmp(buf[current_buf], "byterun\\ocamlrun") == 0) ||
			(_stricmp(buf[current_buf], "byterun\\ocamlrun.exe") == 0) ||
			(_stricmp(buf[current_buf], "ocamlrun") == 0) ||
			(_stricmp(buf[current_buf], "ocamlrun.exe") == 0) ||
			(_stricmp(buf[current_buf], "boot\\ocamlrun") == 0) ||
			(_stricmp(buf[current_buf], "boot\\ocamlrun.exe") == 0) ||
			(_stricmp(buf[current_buf], "..\\boot\\ocamlrun") == 0) ||
			(_stricmp(buf[current_buf], "..\\boot\\ocamlrun.exe") == 0) ||
			(_stricmp(buf[current_buf], "..\\..\\boot\\ocamlrun") == 0) ||
			(_stricmp(buf[current_buf], "..\\..\\boot\\ocamlrun.exe") == 0) ||
			(_stricmp(buf[current_buf], "F:\\tmp\\byterun") == 0) || 
			(_stricmp(buf[current_buf], "F:\\tmp\\byterun.exe") == 0) ||
			(_stricmp(buf[current_buf], "byterun") == 0) || 
			(_stricmp(buf[current_buf], "obj\\ecamlc-nt.exe") == 0) || 
			(_stricmp(buf[current_buf], "byterun.exe") == 0) )
		{
			// contain option
			while (argv[current_token][0] == '-')
			{
				// check if muliti thread application
				if (stricmp(argv[current_token], "-mt") != 0)
				{
					current_buf++;
					len = strlen(argv[current_token]);
					strncpy(buf[current_buf], argv[current_token], len);
					// terminate string
					buf[current_buf][len] = 0;
					// move to next token
				}
				else
				{
					mt_option = TRUE;
				}
				current_token++;
			}
			// not multithreads option
			if (!mt_option) return;
			current_buf++;
			len = strlen(argv[current_token]);
			strncpy(buf[current_buf], argv[current_token], len);
			// terminate string
			buf[current_buf][len] = 0;
			// move to next token
			current_token++;
		}

		mt_option = TRUE;

		// contain argument
		while (argv[current_token][0] == '-')
		{
			current_buf++;
			len = strlen(argv[current_token] + 1);
			if (!buf[current_buf]) buf[current_buf] = (char *) malloc (4 * 16);
			strncpy(buf[current_buf], argv[current_token] + 1, len);
			// terminate string
			buf[current_buf][len] = 0;
			// move to next string
			current_token++;
		}
	}
	__except (EXCEPTION_EXECUTE_HANDLER)
	{
		current_token = -1;
	}
	++current_buf;
	if (buf[current_buf]) { free(buf[current_buf]); buf[current_buf] = 0; }
}

DWORD WINAPI ThreadFunc (LPVOID lpvThreadParm) 
{
	__try
	{
		threadId = GetCurrentThreadId();
//printf ("threadId: %d", threadId);
		caml_main((char **)lpvThreadParm);
	}
	__except ((GetExceptionCode() == PREMATURE_EXIT_EXCEPTION) ? 
		EXCEPTION_EXECUTE_HANDLER :
		EXCEPTION_CONTINUE_SEARCH) 
	{
	}
	return 0;
}

int main(int argc, char **argv)
{
	HANDLE hThread[MAX_THREADS];
	DWORD dwIDThread, dwNoOfThreads = 0;
	int i = 0;
	
#ifdef _WIN32
	expand_command_line(&argc, &argv);
#endif
#if macintosh
	rotatecursor_init (&something_to_do, &have_to_interact);
#endif

	// malloc mutex
	g_hMallocMutex = CreateMutex(NULL, FALSE, NULL);
	// Generic mutex
	g_hGenMutex = CreateMutex(NULL, FALSE, NULL);
	// initialize current token index
	current_token = 0;

	while (current_token != -1)
	{
		char **buf = (char **) malloc(4 * 16);
		for (i = 0; i < 16 ; i++) *(buf + i) = (char *) malloc (4 * 16);
		// disintegrate the command line
		extract_commandLine(argv, buf);

//printf("buf[0]=%s, buf[1]=%s, buf[2]=%s, buf[3]=%s, buf[4]=%s\n", 
//	   buf[0], buf[1], buf[2], buf[3], buf[4]);

		if (!mt_option)
		{
			buf = argv;
			current_token = -1;
		}

		// create thread to execute the command
		hThread[dwNoOfThreads] = CreateThread(NULL,	// no security
			0,							// default stack size = 1MB
			ThreadFunc,					// thread routine
			buf,						// parameter
			0,							// default init flag (running)
			&dwIDThread);				// thread Id
		
//		WaitForSingleObject(hThread[dwNoOfThreads], INFINITE);
		if (hThread[dwNoOfThreads] == NULL)
		{
			fatal_error_arg("Fatal error: Unable to create thread for %s.", 
				*buf);
		}
		else
		{
			++dwNoOfThreads;
		}
		// clean-up buf
		for (i = 0; i < 16 ; i++) 
		{
			if (!*(buf + i)) { free(*(buf + i)); *(buf + i) = NULL; }
		}
		if (!buf) { free(buf); buf = NULL; }
	}

	WaitForMultipleObjects(dwNoOfThreads,	// number of threads to wait
		hThread,							// thread handles
		TRUE,									// wait for all threads
		INFINITE);							// wait forever

	while (dwNoOfThreads > 0) 
	{ --dwNoOfThreads; CloseHandle(hThread[dwNoOfThreads]); }
	
	sys_exit(Val_int(0));
	return 0; /* not reached */
}
