
/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*              Dr. Werner Vogels/Suwat Ch., MEng Project              */
/*                                                                     */
/*  Copyright 1997 Ensemble  Group / CS dept. / Cornell University     */
/*                                                                     */
/***********************************************************************/

#ifndef _MULTITHREADS_H
#define _MULTITHREADS_H


// for Win32 API
#include <windows.h>

// for OcamlDrv
#include "OcamlDrv.h"


// TLS macro name is specified as Thread (specific) Static Local 
// Storage Global Data.
//#define TLS __declspec(thread)
#define TLS 

// maximum number of threads that can be created.
// the exact limit of system 4GB address space = 2000 threads max approx.
#define MAX_THREADS 64

// Useful macro for creating our own software exception
#define MAKESOFTWAREEXCEPTION(Severity, Facility, Exception) \
	((DWORD) ( \
	(Severity << 30) | \
	(1 << 29) | \
	(0 << 28) | \
	(Facility << 16) | \
	(Exception << 0)))

#define PREMATURE_EXIT_EXCEPTION	MAKESOFTWAREEXCEPTION(3,0,1)

// override std exit() method to prevent premature exit
// each thread has its own returnCode
extern TLS int returnCode;
extern void mt_exit(int);

// build mutex across malloc and realloc
extern HANDLE g_hMallocMutex; 
// build mutex across malloc and realloc
extern HANDLE g_hGenMutex; 

///////////////////////end of file//////////////////////////////

#endif // _MULTITHREADS_H
