/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: fix_code.h,v 1.12 1997/09/02 12:53:58 xleroy Exp $ */

/* Handling of blocks of bytecode (endianness switch, threading). */

#ifndef _fix_code_
#define _fix_code_


#include "config.h"
#include "misc.h"
#include "mlvalues.h"

//_//extern TLS code_t start_code;
//_//extern TLS asize_t code_size;
//_//extern TLS unsigned char * saved_code;
//_//extern TLS unsigned char code_md5[16];

void load_code(void * pKByteCode, asize_t len);
//void load_code (int fd, asize_t len);
void fixup_endianness (code_t code, asize_t len);
void set_instruction (code_t pos, opcode_t instr);

#ifdef THREADED_CODE
//_//extern char ** instr_table;
//_//extern char * instr_base;
void thread_code (code_t code, asize_t len);
#endif

#endif
