/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*         Xavier Leroy and Damien Doligez, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: alloc.h,v 1.4 1997/09/02 12:53:55 xleroy Exp $ */

#ifndef _alloc_
#define _alloc_


#include "misc.h"
#include "mlvalues.h"

value alloc (mlsize_t, tag_t);
value alloc_tuple (mlsize_t);
value alloc_string (mlsize_t);
value alloc_final (mlsize_t, final_fun, mlsize_t, mlsize_t);
value copy_string (char *);
value copy_string_array (char **);
#ifndef KAMEEL
value copy_double (double);
#else
value copy_double (__int64);
#endif
value alloc_array (value (*funct) (char *), char ** array);
int convert_flag_list (value, int *);


#endif /* _alloc_ */
