
#include <ntddk.h>
#include <ocamldrv.h>

int errno = 0;
char * __cdecl getenv(char *str)
{
    return NULL;
}

#define KAMEEL_KOEKIE   0xdeadf00d

int __cdecl atoi(
        const char *nptr
        )
{
        int c;              /* current char */
        int total;         /* current total */
        int sign;           /* if '-', then negative, otherwise positive */

        /* skip whitespace */
        while ( *nptr != ' ' && *nptr != '\t')
		nptr++;

        c = (int)(unsigned char)*nptr++;
        sign = c;           /* save sign indication */
        if (c == '-' || c == '+')
            c = (int)(unsigned char)*nptr++;    /* skip sign */

        total = 0;

        while (c >= '0' && c <= '9') {
            total = 10 * total + (c - '0');     /* accumulate digit */
            c = (int)(unsigned char)*nptr++;    /* get next char */
        }

        DbgPrint("atoi %d\n",total);
        if (sign == '-')
            return -total;
        else
            return total;   /* return result, negated if necessary */
}


char * __cdecl malloc (size)
     int size;
{
    int *result = ExAllocatePool(NonPagedPool, size+2*sizeof(int));
	int threadId = getThreadId((PVOID)PsGetCurrentThread());

    if (result != NULL) {
        *result     = KAMEEL_KOEKIE;
        *(result+1) = size;
        result += 2;
    }

	tls[threadId].mem_alloc[tls[threadId].loc] = result;
	(tls[threadId].loc)++;
#ifdef DBG
	DbgPrint("malloc:threadId = %i, ExAllocatePool = %x\n", threadId, result-2); 
#endif
    return result;
}

void __cdecl free(blk)
    int *blk;
{
	if (blk == 0) 
	{
        DbgPrint("free: try th free addr. NULL");
		return;
	}
    blk -= 2;
    if (*blk != KAMEEL_KOEKIE) {
        DbgPrint("free: not one of ours (0x%x)\n",*blk);
        return;
    }
#ifdef DBG
	DbgPrint("free:ExFreePool = %x\n", blk); 
#endif
    ExFreePool(blk);
}

char * __cdecl realloc(blk, size)
    int *blk;
    int size;
{
    int * result;

    blk -= 2;
    if (*blk != KAMEEL_KOEKIE) {
        DbgPrint("free: not one of ours (0x%x)\n",*blk);
        return NULL;
    }
    
    result = (int *)ExAllocatePool(NonPagedPool, size);
    if (result == NULL) return NULL;

    *result     = KAMEEL_KOEKIE;
    *(result+1) = size;

    RtlCopyMemory((result+2), (blk+2), *(blk+1));
    ExFreePool(blk);
#ifdef DBG
	DbgPrint("realloc:ExFreePool = %x\n", blk); 
	DbgPrint("realloc:ExAllocatePool = %x\n", result); 
#endif

    return result+2;
}

int __cdecl open(char * path, int mode, int perm)
{
    DbgPrint("kameel: open %s\n",path);
    return 1;
}

int __cdecl close(int fd)
{
#ifdef DBG
    DbgPrint("kameel: close fd %d\n",fd);
#endif
    return 0;
}

long __cdecl lseek(int fd, long offset, int pos)
{
    DbgPrint("kameel: lseek on fd %d off %d\n",fd,offset);
    return 0;
}


int __cdecl read(int fd , void *b , unsigned int size)
{
    DbgPrint("kameel: read on fd %d, into %d bytes\n", fd, size);
    return 0;
}


int __cdecl rename(const char *src, const char *dst)
{
    DbgPrint("kameel: rename %s -> %s\n",src,dst);
    return 0;
}


int __cdecl unlink(const char *filename)
{
    DbgPrint("kameel: unlink %s\n", filename);
    return 1;
}


int __cdecl write(int fd, const void *b, unsigned int size)
{
//    DbgPrint("kameel: write on fd %d, %d bytes\n",fd, size);
	int i = 0;
	int threadId = getThreadId((PVOID)PsGetCurrentThread());
	DbgPrint("#%i : ", threadId);
	for (; i < size ; i++)
	{
		DbgPrint("%c", *((char *)b+i));
		if (*((char *)b+i) == '\n') 
			if (i < size-1)
				DbgPrint("#%i : ", threadId);
	}
    return size;
}


int __cdecl chdir(const char *dir)
{
    DbgPrint("kameel: chdir to %s\n",dir);
    return 1;  /* EPERM */
}


char * __cdecl getwd(char *dir)
{
    DbgPrint("kameel: getcwd\n");
    RtlCopyBytes(dir, "c:\\temp",8);
    return dir;
}

void * __cdecl getcwd(char *dir, int size)
{
	return getwd(dir);
}

void * __cdecl exit(int exitcode)
{
    DbgPrint("kameel: exit %d\n",exitcode);
}

int __cdecl ui_read(int fd , void *b , unsigned int size)
{
    DbgPrint("kameel: ui_read on fd %d, into %d bytes\n", fd, size);
    return 0;
}

int __cdecl ui_write(int fd , void *b , unsigned int size)
{  
    DbgPrint("kameel: ui_write on fd %d, %d bytes\n", fd, size);
    if (fd == 1 || fd == 2) {
        char print[512];
        if (size > 512)
            size = 512;
        RtlZeroMemory(print,512);
        RtlCopyBytes(print, b, size);
        DbgPrint("Kameel: string -> %s\n", print);
    }
    return size;
}

int __cdecl ui_print_stderr(char *fmt, void * arg)
{
    DbgPrint("kameel: ");
    DbgPrint(fmt,arg);
    return 0;
}

void __cdecl ui_exit(int exitcode)
{
    exit(exitcode);
}

int __cdecl system(char * path)
{
    DbgPrint("kameel: system %s\n", system);
}

int __cdecl signal(int signal, void * action)
{
    DbgPrint("kameel: signal %d\n", signal);
}

int __cdecl kameel_abort (char *msg)
{
	if (msg != NULL) {
		DbgPrint("kameel: %s\n", msg);
	}
	DbgPrint("kameel: aborting .....");
	exit(1);
}

void __cdecl caml_startup(void *);

void
caml_mainloop(void *context)
{
    caml_startup(NULL);
}



PVOID  __cdecl getPeThread() 
{ 
	return (PVOID)PsGetCurrentThread(); 
}

struct THREADLOCALSTORAGE *   __cdecl getThreadLS()
{
	return &(tls[getThreadId(getPeThread())]);
}


int  __cdecl getThreadId(PVOID pethread)
{
	int i;
	for (i = 0 ; i < MAXTHREAD ; i++)
	{
		if 	(peThread[i] == pethread)
		{
//DbgPrint("ThreadTable: find thread %x in ThreadTable pos %i\n", pethread, i);
			return i;
		}
	}
	DbgPrint("ThreadTable: can't find thread %x in ThreadTable.\n", pethread);
	return -1;
}

int __cdecl insertThread(PVOID pethread)
{
	int i;

	for (i = 0 ; i < MAXTHREAD ; i++)
	{
		if 	(peThread[i] == 0)
		{
			peThread[i] = pethread;
DbgPrint("ThreadTable: insert thread %x in ThreadTable pos %i\n", pethread, i);
			return i;
		}			
	}
	DbgPrint("ThreadTable: ThreadTable is full.\n");
	return -1;
}

int __cdecl removeThread(PVOID pethread)
{
	int i;
	for (i = 0 ; i < MAXTHREAD ; i++)
	{
		if 	(peThread[i] == pethread)
		{
			peThread[i] = 0;
DbgPrint("ThreadTable: remove thread %x from ThreadTable pos %i\n", pethread, i);
			return i;
		}			
	}
	DbgPrint("ThreadTable: can't find thread %x in ThreadTable.\n", pethread);
	return -1;
}
