/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: stacks.c,v 1.11 1997/11/20 15:30:43 xleroy Exp $ */

/* To initialize and resize the stacks */

#include "multithreads.h"
#include <string.h>
#include "config.h"
#include "fail.h"
#include "misc.h"
#include "mlvalues.h"
#include "stacks.h"

//_//TLS value * stack_low;
//_//TLS value * stack_high;
//_//TLS value * stack_threshold;
//_//TLS value * extern_sp;
//_//TLS value * trapsp;
//_//TLS value * trap_barrier;
//_//TLS value global_data;

//_//TLS unsigned long max_stack_size;            /* also used in gc_ctrl.c */

void init_stack (long unsigned int initial_max_size)
{
int threadId = getThreadId(getPeThread());
  tls[threadId].stack_low = (value *) stat_alloc(Stack_size);
  tls[threadId].stack_high = tls[threadId].stack_low + Stack_size / sizeof (value);
  tls[threadId].stack_threshold = tls[threadId].stack_low + Stack_threshold / sizeof (value);
  tls[threadId].extern_sp = tls[threadId].stack_high;
  tls[threadId].trapsp = tls[threadId].stack_high;
  tls[threadId].trap_barrier = tls[threadId].stack_high + 1;
  tls[threadId].max_stack_size = initial_max_size;
  gc_message ("Initial stack limit: %luk bytes\n",
	      tls[threadId].max_stack_size / 1024 * sizeof (value));
}

void realloc_stack(void)
{        
  asize_t size;
  value * new_low, * new_high, * new_sp;
  value * p;
int threadId = getThreadId(getPeThread());

  Assert(tls[threadId].extern_sp >= tls[threadId].stack_low);
  size = tls[threadId].stack_high - tls[threadId].stack_low;
  if (size >= tls[threadId].max_stack_size) raise_stack_overflow();
  size *= 2;
  gc_message ("Growing stack to %luk bytes\n",
              (unsigned long) size * sizeof(value) / 1024);
  new_low = (value *) stat_alloc(size * sizeof(value));
  new_high = new_low + size;

#define shift(ptr) \
    ((char *) new_high - ((char *) tls[threadId].stack_high - (char *) (ptr)))

  new_sp = (value *) shift(tls[threadId].extern_sp);
  bcopy((char *) tls[threadId].extern_sp,
        (char *) new_sp,
        (tls[threadId].stack_high - tls[threadId].extern_sp) * sizeof(value));
  stat_free(tls[threadId].stack_low);
  tls[threadId].trapsp = (value *) shift(tls[threadId].trapsp);
  tls[threadId].trap_barrier = (value *) shift(tls[threadId].trap_barrier);
  for (p = tls[threadId].trapsp; p < new_high; p = Trap_link(p))
    Trap_link(p) = (value *) shift(Trap_link(p));
  tls[threadId].stack_low = new_low;
  tls[threadId].stack_high = new_high;
  tls[threadId].stack_threshold = tls[threadId].stack_low + Stack_threshold / sizeof (value);
  tls[threadId].extern_sp = new_sp;

#undef shift
}

void change_max_stack_size (long unsigned int new_max_size)
{
int threadId = getThreadId(getPeThread());
  asize_t size = tls[threadId].stack_high - tls[threadId].extern_sp + Stack_threshold / sizeof (value);

  if (new_max_size < size) new_max_size = size;
  if (new_max_size != tls[threadId].max_stack_size){
    gc_message ("Changing stack limit to %luk bytes\n",
                new_max_size * sizeof (value) / 1024);
  }
  tls[threadId].max_stack_size = new_max_size;
}
