/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*         Xavier Leroy and Damien Doligez, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: roots.c,v 1.15 1997/11/20 15:30:42 xleroy Exp $ */

/* To walk the memory roots for garbage collection */

#include "multithreads.h"
#include "memory.h"
#include "major_gc.h"
#include "minor_gc.h"
#include "misc.h"
#include "mlvalues.h"
#include "roots.h"
#include "stacks.h"

//_//TLS struct caml__roots_block *local_roots = NULL;

//_//struct global_root {
//_//  value * root;
//_//  struct global_root * next;
//_//};

//_//TLS struct global_root * global_roots = NULL;
//TLS static struct global_root * global_roots = NULL;

TLS void (*scan_roots_hook) (scanning_action f) = NULL;

/* Register a global C root */

void register_global_root(value *r)
{
  struct global_root * gr;
int threadId = getThreadId(getPeThread());
  gr = (struct global_root *) stat_alloc(sizeof(struct global_root));
  gr->root = r;
  gr->next = tls[threadId].global_roots;
  tls[threadId].global_roots = gr;
}

/* Un-register a global C root */

void remove_global_root(value *r)
{
  struct global_root ** gp, * gr;
int threadId = getThreadId(getPeThread());
  for (gp = &tls[threadId].global_roots; *gp != NULL; gp = &(*gp)->next) {
    gr = *gp;
// suwat's modification if r == NULL , remove all
    if (r == NULL) {
      stat_free(gr);
    } else
    if (gr->root == r) {
      *gp = gr->next;
      stat_free(gr);
      return;
    }
  }
}


/* Call [oldify] on all roots except [global_data] */

void oldify_local_roots (void)
{
  register value * sp;
  struct global_root * gr;
  struct caml__roots_block *lr;
  long i, j;
int threadId = getThreadId(getPeThread());

  /* The stack */
  for (sp = tls[threadId].extern_sp; sp < tls[threadId].stack_high; sp++) {
    oldify (*sp, sp);
  }
  /* Local C roots */
  for (lr = tls[threadId].local_roots; lr != NULL; lr = lr->next) {
    for (i = 0; i < lr->ntables; i++){
      for (j = 0; j < lr->nitems; j++){
        sp = &(lr->tables[i][j]);
        oldify (*sp, sp);
      }
    }
  }
  /* Global C roots */
  for (gr = tls[threadId].global_roots; gr != NULL; gr = gr->next) {
    oldify(*(gr->root), gr->root);
  }
  /* Hook */
  if (scan_roots_hook != NULL) (*scan_roots_hook)(oldify);
}

/* Call [darken] on all roots */

void darken_all_roots (void)
{
  do_roots (darken);
}

void do_roots (scanning_action f)
{
  struct global_root * gr;
int threadId = getThreadId(getPeThread());

  /* Global variables */
  f(tls[threadId].global_data, &tls[threadId].global_data);

  /* The stack and the local C roots */
  do_local_roots(f, tls[threadId].extern_sp, tls[threadId].stack_high, tls[threadId].local_roots);

  /* Global C roots */
  for (gr = tls[threadId].global_roots; gr != NULL; gr = gr->next) {
    f (*(gr->root), gr->root);
  }
  /* Hook */
  if (scan_roots_hook != NULL) (*scan_roots_hook)(f);
}

void do_local_roots (scanning_action f, value *stack_low, value *stack_high, struct caml__roots_block *local_roots)
{
  register value * sp;
  struct caml__roots_block *lr;
  int i, j;
int threadId = getThreadId(getPeThread());

  for (sp = stack_low; sp < stack_high; sp++) {
    f (*sp, sp);
  }
  for (lr = tls[threadId].local_roots; lr != NULL; lr = lr->next) {
    for (i = 0; i < lr->ntables; i++){
      for (j = 0; j < lr->nitems; j++){
        sp = &(lr->tables[i][j]);
        f (*sp, sp);
      }
    }
  }
}

