
/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*              Dr. Werner Vogels/Suwat Ch., MEng Project              */
/*                                                                     */
/*  Copyright 1997 Ensemble  Group / CS dept. / Cornell University     */
/*                                                                     */
/***********************************************************************/

// override std exit() method to prevent premature exit
// each thread has its own returnCode
#include "multithreads.h"

HANDLE g_hMallocMutex = NULL;
HANDLE g_hGenMutex = NULL;
TLS int returnCode = 0;
void mt_exit(int exitCode)
{
#ifdef _MULTITHREADS_H
	returnCode = exitCode;
//	RaiseException(PREMATURE_EXIT_EXCEPTION, 0, 1, &returnCode);
	exit(exitCode);
#else
	exit(exitCode);
#endif
}

int getThreadId(PVOID pv)
{
	return 0;
}

PVOID getPeThread()
{
	return (PVOID)0;
}

int ui_print_stderr(char *fmt, void * arg)
{
    return 0;
}

void ui_exit(int exitcode)
{
	return;
}

int kameel_abort (char *msg)
{
	if (msg != NULL) {
		DbgPrint("kameel: %s\n", msg);
	}
	DbgPrint("kameel: aborting .....");
	exit(1);
}


void tlsIntialize(void)
{
	int threadId;
	opcode_t callback1_code[] = {ACC1, APPLY1, POP, 1, STOP};
	opcode_t callback2_code[] = {ACC2, APPLY2, POP, 1, STOP};
	opcode_t callback3_code[] = {ACC3, APPLY3, POP, 1, STOP};
	struct named_value * named_value_table[Named_value_size] = { NULL, };
	struct {
		value filler1;
		header_t h;
		value first_bp;
		value filler2;
	} sentinel = {0, Make_header (0, 0, Blue), 0, 0};
	unsigned char printable_chars_ascii[] = /* 0x20-0x7E */
  "\000\000\000\000\377\377\377\377\377\377\377\377\377\377\377\177\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000";
	unsigned char printable_chars_iso[] = /* 0x20-0x7E 0xA1-0xFF */
  "\000\000\000\000\377\377\377\377\377\377\377\377\377\377\377\177\000\000\000\000\376\377\377\377\377\377\377\377\377\377\377\377";

	// initialize memory array 
	for (threadId = 0 ; threadId < MAXTHREAD; threadId++)
	{
		tls[threadId].mem_alloc[MAXMEM - 1] = 0;

		tls[threadId].callback_depth = 0;
		memcpy(tls[threadId].callback1_code, callback1_code, sizeof(tls[threadId].callback1_code));
		memcpy(tls[threadId].callback2_code, callback2_code, sizeof(tls[threadId].callback2_code));
		memcpy(tls[threadId].callback3_code, callback3_code, sizeof(tls[threadId].callback3_code));
		tls[threadId].callback_code_threaded = 0;
		memcpy(tls[threadId].named_value_table, named_value_table, sizeof(named_value_table));
		tls[threadId].initial_ofs = 1;
		tls[threadId].extern_table = NULL;

		tls[threadId].dbg_socket = -1;

		memcpy(&tls[threadId].sentinel, &sentinel, sizeof(sentinel));
		tls[threadId].fl_prev = NULL;
		tls[threadId].fl_last = NULL;
		tls[threadId].fl_merge = NULL;
		tls[threadId].fl_cur_size = 0;
		
		tls[threadId].stat_minor_words = 0;
		tls[threadId].stat_promoted_words = 0;
		tls[threadId].stat_major_words = 0;
		tls[threadId].stat_minor_collections = 0;
		tls[threadId].stat_major_collections = 0;
		tls[threadId].stat_heap_size = 0;           /* bytes */
		tls[threadId].stat_compactions = 0;
		
		tls[threadId].young_start = NULL;
		tls[threadId].young_end = NULL;
		tls[threadId].young_ptr = NULL;
		tls[threadId].young_limit = NULL;
		tls[threadId].ref_table = NULL;
		tls[threadId].ref_table_ptr = NULL;
		tls[threadId].in_minor_collection = 0;

		tls[threadId].seed = 0x12345;

		tls[threadId].async_signal_mode = 0;
		tls[threadId].pending_signal = 0;
		tls[threadId].something_to_do = 0;
		tls[threadId].force_major_slice = 0;
		tls[threadId].signal_handlers = 0;
		
		tls[threadId].verbose_init = 0;
		
		tls[threadId].icount = 0;
		tls[threadId].trace_flag = 0;

		memcpy(tls[threadId].printable_chars_ascii, printable_chars_ascii, sizeof(printable_chars_ascii));
		memcpy(tls[threadId].printable_chars_iso, printable_chars_iso, sizeof(printable_chars_iso));
		
		tls[threadId].local_roots = NULL;
		tls[threadId].global_roots = NULL;
		
		tls[threadId].weak_list_head = 0;

		peThread[threadId] = 0;
	}
//	KeInitializeSemaphore(&InsertSemaphore, 1, 1);
//	KeInitializeSemaphore(&IsFullSemaphore, MAXTHREAD, MAXTHREAD);
	
//	DbgPrint("OCAMLDRV.SYS: All tls initialized!\n");
}



int mt_main (int argc, char *argv[])
{
	//
	// prepare heap memory.
	//
	
    OCAML_BYTECODE_INFO obi;
	DWORD fileSize, dwByteLeft, code_size;
    HANDLE hFile;
	LPCTSTR fileName;

	if (argc == 1)
	{
		fileName = argv[0];
	}
	else if (argc == 2)
    {
        // Display usage message
		fileName = argv[1];
    }
	else
    {
        // Display usage message
        printf ("\tExample: 'ocamltry <bytecode>'\n");
        goto done;
    }

	
	// Open the file for reading.
	if ((hFile = CreateFile(fileName,
		GENERIC_READ,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL
		)) == ((HANDLE)-1))
	{
		printf ("Can't open file %s !\n", fileName);
		goto done;
	}
	
	// size of bytecode to be allocate	
	fileSize = dwByteLeft = obi.ByteCodeSize = GetFileSize(hFile, NULL);

	obi.KByteCode = (PUCHAR) malloc (sizeof(UCHAR) * fileSize);

	if (!obi.KByteCode)
	{
		printf ("Not enough memory!\n");
		goto close_file;
	}
	
	// initialize bytecode offset
	obi.ByteCodeOffset = 0;  		
	
	// Try to feed the bytecode into kernel
	while (1)
	{
		DWORD dwNumberOfBytesToRead = 
			(dwByteLeft <= BYTE_PACKAGE_SIZE) ? dwByteLeft : BYTE_PACKAGE_SIZE;

		// read file content
		if ( !ReadFile( hFile,   // handle of file to read 
			obi.KByteCode + obi.ByteCodeOffset, // address of buffer that receives data 
			dwNumberOfBytesToRead,  // number of bytes to read 
			&(obi.ByteCodeSize),   // address of number of bytes read 
			NULL // address of structure for data 
			))
		{
			printf ("Can't read content of file!\n");
			goto close_file;
		}
		
		
		// adjust offset
		obi.ByteCodeOffset += obi.ByteCodeSize;

		// check if there is byte left to transfer
		if ((dwByteLeft -= obi.ByteCodeSize) <= 0)
		{
			// successfully done
			if (dwByteLeft == 0) break;
			printf ("Kernel Ocaml Bytecode feed Fail!\n");
			goto close_file;
		}
	}
	
	obi.ByteCodeSize = fileSize;

	tlsIntialize();

	if ((code_size = caml_main(&obi)) == 0) goto close_file;
	
	interpreter(code_size);

	free(obi.KByteCode);
	
close_file:
	// Close file
	CloseHandle(hFile);
	
done: 
	return 0;
}


///////////////////////end of file//////////////////////////////

