/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*             Damien Doligez, projet Para, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: minor_gc.c,v 1.17 1997/11/20 15:30:42 xleroy Exp $ */

#include "multithreads.h"
#include <string.h>
#include "config.h"
#include "fail.h"
#include "gc.h"
#include "gc_ctrl.h"
#include "major_gc.h"
#include "memory.h"
#include "minor_gc.h"
#include "misc.h"
#include "mlvalues.h"
#include "roots.h"
#include "signals.h"

//_//TLS asize_t minor_heap_size;
//_//TLS char *young_start = NULL, *young_end = NULL;
//_//TLS char *young_ptr = NULL, *young_limit = NULL;
//_//TLS value **ref_table = NULL, **ref_table_end, **ref_table_threshold;
//TLS static value **ref_table = NULL, **ref_table_end, **ref_table_threshold;
//_//TLS value **ref_table_ptr = NULL, **ref_table_limit;
//_//TLS asize_t ref_table_size, ref_table_reserve;
//TLS static asize_t ref_table_size, ref_table_reserve;
//_//TLS int in_minor_collection = 0;

void set_minor_heap_size (asize_t size)
{
  char *new_heap;
  value **new_table;
int threadId = getThreadId(getPeThread());

  Assert (size >= Minor_heap_min);
  Assert (size <= Minor_heap_max);
  Assert (size % sizeof (value) == 0);
  if (tls[threadId].young_ptr != tls[threadId].young_end) minor_collection ();
                                           Assert (tls[threadId].young_ptr == tls[threadId].young_end);
  new_heap = (char *) stat_alloc (size);
  if (tls[threadId].young_start != NULL){
    stat_free (tls[threadId].young_start);
  }
  tls[threadId].young_start = new_heap;
  tls[threadId].young_end = new_heap + size;
  tls[threadId].young_limit = tls[threadId].young_start;
  tls[threadId].young_ptr = tls[threadId].young_end;
  tls[threadId].minor_heap_size = size;

  tls[threadId].ref_table_size = tls[threadId].minor_heap_size / sizeof (value) / 8;
  tls[threadId].ref_table_reserve = 256;
  new_table = (value **) stat_alloc ((tls[threadId].ref_table_size + tls[threadId].ref_table_reserve)
                                     * sizeof (value *));
  if (tls[threadId].ref_table != NULL) stat_free (tls[threadId].ref_table);
  tls[threadId].ref_table = new_table;
  tls[threadId].ref_table_ptr = tls[threadId].ref_table;
  tls[threadId].ref_table_threshold = tls[threadId].ref_table + tls[threadId].ref_table_size;
  tls[threadId].ref_table_limit = tls[threadId].ref_table_threshold;
  tls[threadId].ref_table_end = tls[threadId].ref_table + tls[threadId].ref_table_size + tls[threadId].ref_table_reserve;
}

void oldify (value v, value *p)
{
  value result, field0;
  header_t hd;
  mlsize_t sz, i;
  int tag;
int threadId = getThreadId(getPeThread());

 tail_call:
  if (Is_block (v) && Is_young (v)){
    Assert (Hp_val (v) >= tls[threadId].young_ptr);
    hd = Hd_val (v);
    tag = Tag_hd (hd);
    if (Is_blue_hd (hd)){    /* Already forwarded ? */
      *p = Field (v, 0);     /* Then the forward pointer is the first field. */
    }else if (tag == Infix_tag) {
      mlsize_t offset = Infix_offset_hd (hd);
      oldify(v - offset, p);
      *p += offset;
    }else if (tag >= No_scan_tag){
      sz = Wosize_hd (hd);
      result = alloc_shr (sz, tag);
      for (i = 0; i < sz; i++) Field(result, i) = Field(v, i);
      Hd_val (v) = Bluehd_hd (hd);            /* Put the forward flag. */
      Field (v, 0) = result;                  /* And the forward pointer. */
      *p = result;
    }else{
      /* We can do recursive calls before all the fields are filled, because
         we will not be calling the major GC. */
      sz = Wosize_hd (hd);
      result = alloc_shr (sz, tag);
      *p = result;
      field0 = Field (v, 0);
      Hd_val (v) = Bluehd_hd (hd);            /* Put the forward flag. */
      Field (v, 0) = result;                  /* And the forward pointer. */
      if (sz == 1) {
        p = &Field (result, 0);
        v = field0;
        goto tail_call;
      } else {
        oldify (field0, &Field (result, 0));
        for (i = 1; i < sz - 1; i++){
          oldify (Field(v, i), &Field (result, i));
        }
        p = &Field (result, i);
        v = Field (v, i);
        goto tail_call;
      }
    }
  }else{
    *p = v;
  }
}

void minor_collection (void)
{
int threadId = getThreadId(getPeThread());
  value **r;
  long prev_alloc_words = tls[threadId].allocated_words;

  tls[threadId].in_minor_collection = 1;
  gc_message ("<", 0);
  oldify_local_roots();
  for (r = tls[threadId].ref_table; r < tls[threadId].ref_table_ptr; r++) oldify (**r, *r);
  tls[threadId].stat_minor_words += Wsize_bsize (tls[threadId].young_end - tls[threadId].young_ptr);
  tls[threadId].young_ptr = tls[threadId].young_end;
  tls[threadId].ref_table_ptr = tls[threadId].ref_table;
  tls[threadId].ref_table_limit = tls[threadId].ref_table_threshold;
  gc_message (">", 0);
  tls[threadId].in_minor_collection = 0;

  tls[threadId].stat_promoted_words += tls[threadId].allocated_words - prev_alloc_words;
  ++tls[threadId].stat_minor_collections;
  major_collection_slice ();
  tls[threadId].force_major_slice = 0;
}

value check_urgent_gc (value extra_root)
{
int threadId = getThreadId(getPeThread());

  if (tls[threadId].force_major_slice) {
    Begin_root(extra_root);
      minor_collection();
    End_roots();
  }
  return extra_root;
}

void realloc_ref_table (void)
{
int threadId = getThreadId(getPeThread());
									Assert (tls[threadId].ref_table_ptr == tls[threadId].ref_table_limit);
                                  Assert (tls[threadId].ref_table_limit <= tls[threadId].ref_table_end);
                            Assert (tls[threadId].ref_table_limit >= tls[threadId].ref_table_threshold);

  if (tls[threadId].ref_table_limit == tls[threadId].ref_table_threshold){
    gc_message ("ref_table threshold crossed\n", 0);
    tls[threadId].ref_table_limit = tls[threadId].ref_table_end;
    urge_major_slice ();
  }else{ /* This will almost never happen with the bytecode interpreter. */
    asize_t sz;
    asize_t cur_ptr = tls[threadId].ref_table_ptr - tls[threadId].ref_table;
                                                  Assert (tls[threadId].force_major_slice);

    tls[threadId].ref_table_size *= 2;
    sz = (tls[threadId].ref_table_size + tls[threadId].ref_table_reserve) * sizeof (value *);
    gc_message ("Growing ref_table to %ldk bytes\n", (long) sz / 1024);
    tls[threadId].ref_table = (value **) realloc ((char *) tls[threadId].ref_table, sz);
    if (tls[threadId].ref_table == NULL) fatal_error ("Fatal error: ref_table overflow\n");
    tls[threadId].ref_table_end = tls[threadId].ref_table + tls[threadId].ref_table_size + tls[threadId].ref_table_reserve;
    tls[threadId].ref_table_threshold = tls[threadId].ref_table + tls[threadId].ref_table_size;
    tls[threadId].ref_table_ptr = tls[threadId].ref_table + cur_ptr;
    tls[threadId].ref_table_limit = tls[threadId].ref_table_end;
  }
}
