/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: callback.c,v 1.3 1997/09/02 12:53:56 xleroy Exp $ */

/* Callbacks from C to Caml */

#include "multithreads.h"
#include <string.h>
#include "callback.h"
#include "memory.h"
#include "mlvalues.h"

/* Bytecode callbacks (implemented in asm for the native code compiler) */

#ifndef NATIVE_CODE

#include "interp.h"
#include "instruct.h"
#include "fix_code.h"
#include "stacks.h"

//_//TLS int callback_depth = 0;

//_//TLS opcode_t callback1_code[] = { ACC1, APPLY1, POP, 1, STOP };
//_//TLS opcode_t callback2_code[] = { ACC2, APPLY2, POP, 1, STOP };
//_//TLS opcode_t callback3_code[] = { ACC3, APPLY3, POP, 1, STOP };
//TLS static opcode_t callback1_code[] = { ACC1, APPLY1, POP, 1, STOP };
//TLS static opcode_t callback2_code[] = { ACC2, APPLY2, POP, 1, STOP };
//TLS static opcode_t callback3_code[] = { ACC3, APPLY3, POP, 1, STOP };

#ifdef THREADED_CODE

//_//TLS int callback_code_threaded = 0;
//TLS static int callback_code_threaded = 0;

static void thread_callback(void)
{
int threadId = getThreadId(getPeThread());

  thread_code(tls[threadId].callback1_code, sizeof(tls[threadId].callback1_code));
  thread_code(tls[threadId].callback2_code, sizeof(tls[threadId].callback2_code));
  thread_code(tls[threadId].callback3_code, sizeof(tls[threadId].callback3_code));
  tls[threadId].callback_code_threaded = 1;
}

#define Init_callback() if (!tls[threadId].callback_code_threaded) thread_callback()

#else

#define Init_callback()

#endif

value callback(value closure, value arg)
{
  value res;
int threadId = getThreadId(getPeThread());

  Init_callback();
  tls[threadId].extern_sp -= 2;
  tls[threadId].extern_sp[0] = arg;
  tls[threadId].extern_sp[1] = closure;
  tls[threadId].callback_depth++;
  res = interprete(tls[threadId].callback1_code, sizeof(tls[threadId].callback1_code));
  tls[threadId].callback_depth--;
  return res;
}

value callback2(value closure, value arg1, value arg2)
{
  value res;
int threadId = getThreadId(getPeThread());

  Init_callback();
  tls[threadId].extern_sp -= 3;
  tls[threadId].extern_sp[0] = arg1;
  tls[threadId].extern_sp[1] = arg2;
  tls[threadId].extern_sp[2] = closure;
  tls[threadId].callback_depth++;
  res = interprete(tls[threadId].callback2_code, sizeof(tls[threadId].callback2_code));
  tls[threadId].callback_depth--;
  return res;
}

value callback3(value closure, value arg1, value arg2, value arg3)
{
  value res;
int threadId = getThreadId(getPeThread());

  Init_callback();
  tls[threadId].extern_sp -= 4;
  tls[threadId].extern_sp[0] = arg1;
  tls[threadId].extern_sp[1] = arg2;
  tls[threadId].extern_sp[2] = arg3;
  tls[threadId].extern_sp[3] = closure;
  tls[threadId].callback_depth++;
  res = interprete(tls[threadId].callback3_code, sizeof(tls[threadId].callback3_code));
  tls[threadId].callback_depth--;
  return res;
}

#endif

/* Naming of Caml values */

//_//struct named_value {
//_//  value val;
//_//  struct named_value * next;
//_//  char name[1];
//_//};

#define Named_value_size 13

//_//TLS struct named_value * named_value_table[Named_value_size] = { NULL, };
//TLS static struct named_value * named_value_table[Named_value_size] = { NULL, };

static unsigned int hash_value_name(char *name)
{
  unsigned int h;
  for (h = 0; *name != 0; name++) h = h * 19 + *name;
  return h % Named_value_size;
}

value register_named_value(value vname, value val) /* ML */
{
  struct named_value * nv;
  char * name = String_val(vname);
  unsigned int h = hash_value_name(name);
int threadId = getThreadId(getPeThread());

  nv = (struct named_value *)
         stat_alloc(sizeof(struct named_value) + strlen(name));
  strcpy(nv->name, name);
  nv->val = val;
  nv->next = tls[threadId].named_value_table[h];
  tls[threadId].named_value_table[h] = nv;
  register_global_root(&nv->val);
  return Val_unit;
}

value * caml_named_value(char *name)
{
  struct named_value * nv;
int threadId = getThreadId(getPeThread());
  for (nv = tls[threadId].named_value_table[hash_value_name(name)];
       nv != NULL;
       nv = nv->next) {
    if (strcmp(name, nv->name) == 0) return &nv->val;
  }
  return NULL;
}
