
#include "windows.h"
#include "winioctl.h"
#include "stdio.h"
#include "stdlib.h"
#include "ioaccess.h"
#include "tchar.h"
#include "ocamldrv.h"


int
__cdecl
main(
    IN int  argc,
    IN char *argv[])
{
    HANDLE hOcamlDrv;
    HANDLE hFile;
	OCAML_BYTECODE_INFO obi;
	DWORD dwByteLeft;
    DWORD cbReturned, fileSize;
	int i, rStatus = 0;
	LPCTSTR fileName;
 
    if (argc == 1)
	{
		fileName = argv[0];
	}
    else if (argc == 2)
	{
		fileName = argv[1];
	}
	else
    {
        // Display usage message
        printf ("\tExample: 'ocamlfeed <bytecode>'\n");
        goto done;
    }


    // Try to open the device
    if ((hOcamlDrv = CreateFile("\\\\.\\OCAMLDRV",
			GENERIC_READ | GENERIC_WRITE,
			0,
			NULL,
			OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,
			NULL
			)) == ((HANDLE)-1))
    {
		printf ("Can't get a handle to OCAMLDRV driver\n");
        goto done;
    }


	for (i = 1 ; i < 2 ; ++i)
	{
		
		// Open the file for reading.
		if ((hFile = CreateFile(fileName,
			GENERIC_READ,
			FILE_SHARE_READ,
			NULL,
			OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,
			NULL
			)) == ((HANDLE)-1))
		{
			printf ("Can't open file %s !\n", fileName);
			goto close_device;
		}

		// size of bytecode to be allocate	
		fileSize = dwByteLeft = obi.ByteCodeSize = GetFileSize(hFile, NULL);
		
		
		// Try to feed the size of bytecode into kernel
		if ( !DeviceIoControl (hOcamlDrv,
			(DWORD) IOCTL_OCAML_BYTECODE_SIZE,
			&obi,
			sizeof(OCAML_BYTECODE_INFO),
			&(obi.KByteCode),
			sizeof(PVOID),
			&cbReturned,
			0) )
		{
			printf ("Can't allocate bytecode in kernel!\n");
			goto close_file;
		}


		// initialize bytecode offset
		obi.ByteCodeOffset = 0;  		
		
		// Try to feed the bytecode into kernel
		while (1)
		{
			DWORD dwNumberOfBytesToRead = 
				(dwByteLeft <= BYTE_PACKAGE_SIZE) ? dwByteLeft : BYTE_PACKAGE_SIZE;
			
			// read file content
			if ( !ReadFile( hFile,   // handle of file to read 
				obi.ByteCode, // address of buffer that receives data 
				dwNumberOfBytesToRead,  // number of bytes to read 
				&(obi.ByteCodeSize),   // address of number of bytes read 
				NULL // address of structure for data 
				))
			{
				printf ("Can't read content of file!\n");
				goto close_file;
			}

		
			// feed to Ocaml Device Driver
			if ( !DeviceIoControl ( hOcamlDrv,
				(DWORD) IOCTL_OCAML_BYTECODE_FEED,
				&obi,
				sizeof(OCAML_BYTECODE_INFO),
				NULL,
				0,
				&cbReturned,
				0))
			{	
				printf ("Kernel Ocaml Bytecode Bytecode feed Fail!\n");
				goto close_file;
			}
			

			// adjust offset
			obi.ByteCodeOffset += obi.ByteCodeSize;
			
			// check if there is byte left to transfer
			if ((dwByteLeft -= obi.ByteCodeSize) <= 0)
			{
				// successfully done
				if (dwByteLeft == 0)
				{
					printf ("Kernel Ocaml Bytecode feed Successful!\n");
					rStatus = 1;
					break;
				}
				printf ("Kernel Ocaml Bytecode feed Fail!\n");
				goto close_file;
			}
		}

		obi.ByteCodeSize = fileSize;

		// feed to Ocaml Device Driver
		if ( !DeviceIoControl ( hOcamlDrv,
			(DWORD) IOCTL_OCAML_BYTECODE_INTERPRETE,
			&obi,
			sizeof(OCAML_BYTECODE_INFO),
			NULL,
			0,
			&cbReturned,
			0))
		{	
			printf ("Kernel Ocaml Bytecode Interpreter Fail!\n");
			goto close_file;
		}

		printf ("Kernel Ocaml Bytecode Interpreter Successful!\n");

		// feed to Ocaml Device Driver
		if ( !DeviceIoControl ( hOcamlDrv,
			(DWORD) IOCTL_OCAML_BYTECODE_CLEAN,
			&obi,
			sizeof(OCAML_BYTECODE_INFO),
			NULL,
			0,
			&cbReturned,
			0))
		{	
			printf ("Kernel Ocaml Bytecode Cleanup Fail!\n");
			goto close_file;
		}

		printf ("Kernel Ocaml Bytecode Cleanup Successful!\n");

close_file:
		// Close file
		CloseHandle(hFile);
	}

close_device:
	// Close device driver
    CloseHandle(hOcamlDrv);

done: 
    return rStatus;

}
