#ifndef _OCAMLDRV_H
#define _OCAMLDRV_H

#include "instruct.h"

//
// Debugging purpose.
//

#ifdef DBG
#undef DBG
#endif
#ifdef SINGLETHREAD
#undef SINGLETHREAD
#endif

//#define DBG

//#define SINGLETHREAD

//
// Define package size for ocaml bytecode that is fed from user space.
//

#define BYTE_PACKAGE_SIZE  128

//
// Define the various device type values.  Note that values used by Microsoft
// Corporation are in the range 0-32767, and 32768-65535 are reserved for use
// by customers.
//

#define FILE_DEVICE_OCAML_BYTECODE  0x00008000


//
// Macro definition for defining IOCTL and FSCTL function control codes.  Note
// that function codes 0-2047 are reserved for Microsoft Corporation, and
// 2048-4095 are reserved for customers.
//

#define OCAML_BYTECODE_IOCTL_INDEX  0x800


//
// Define our own private IOCTL
//

#define IOCTL_OCAML_BYTECODE_SIZE   CTL_CODE(FILE_DEVICE_OCAML_BYTECODE, \
											 OCAML_BYTECODE_IOCTL_INDEX, \
											 METHOD_BUFFERED, \
                                             FILE_ANY_ACCESS)

#define IOCTL_OCAML_BYTECODE_FEED   CTL_CODE(FILE_DEVICE_OCAML_BYTECODE, \
											 OCAML_BYTECODE_IOCTL_INDEX+1, \
											 METHOD_BUFFERED, \
                                             FILE_ANY_ACCESS)

#define IOCTL_OCAML_BYTECODE_INTERPRETE   CTL_CODE(FILE_DEVICE_OCAML_BYTECODE, \
											 OCAML_BYTECODE_IOCTL_INDEX+2, \
											 METHOD_BUFFERED, \
                                             FILE_ANY_ACCESS)

#define IOCTL_OCAML_BYTECODE_CLEAN   CTL_CODE(FILE_DEVICE_OCAML_BYTECODE, \
											 OCAML_BYTECODE_IOCTL_INDEX+3, \
											 METHOD_BUFFERED, \
                                             FILE_ANY_ACCESS)


//
// Define our own private IOCTL
//

#define STATUS_NOT_OCAML_BYTECODE    ((NTSTATUS)0xC0000271L)

//
// Structure for Ocaml Bytecode Info passed to kernel
//

typedef struct
{
	UCHAR			ByteCode[BYTE_PACKAGE_SIZE];
	PUCHAR			KByteCode;
	ULONG			ByteCodeSize;
	ULONG			ByteCodeOffset;
} OCAML_BYTECODE_INFO, *POCAML_BYTECODE_INFO;

//
// thread local storage
//

#define MAXMEM 32
#define MAXTHREAD 32

typedef int int32;
typedef int32 opcode_t;
typedef opcode_t * code_t;
typedef long value;
typedef unsigned long header_t;
typedef unsigned long mlsize_t;
typedef unsigned int tag_t;
typedef unsigned long color_t;
typedef unsigned long mark_t;
typedef unsigned long byteoffset_t;
#ifdef __STDC__
typedef size_t asize_t;
#else
typedef int asize_t;
#endif

#define Named_value_size 13

struct named_value {
  value val;
  struct named_value * next;
  char name[1];
};

#ifndef IO_BUFFER_SIZE
#define IO_BUFFER_SIZE 4096
#endif

#define Blue  (2 << 8)
#define Make_header(wosize, tag, color)                                       \
       ((header_t) (((header_t) (wosize) << 10)                               \
                    + (color)                                                 \
                    + (tag_t) (tag)))
#define Fl_head ((char *) (&(tls[threadId].sentinel.first_bp)))

#ifdef __alpha
typedef int page_table_entry;
#else
typedef char page_table_entry;
#endif

struct channel {
  int fd;                       /* Unix file descriptor */
  long offset;                  /* Absolute position of fd in the file */
  char * end;                   /* Physical end of the buffer */
  char * curr;                  /* Current position in the buffer */
  char * max;                   /* Logical end of the buffer (for input) */
  void * mutex;                 /* Placeholder for mutex (for systhreads) */
  char buff[IO_BUFFER_SIZE];    /* The buffer itself */
};

struct extern_obj {
  byteoffset_t ofs;
  value obj;
};

struct caml__roots_block {
  struct caml__roots_block *next;
  long ntables;
  long nitems;
  value *tables [5];
};

struct global_root {
	value * root;
	struct global_root * next;
};

struct THREADLOCALSTORAGE {
	int *mem_alloc[MAXMEM];
	int loc;

// callback.c
	int callback_depth;
	opcode_t callback1_code[5];
	opcode_t callback2_code[5];
	opcode_t callback3_code[5];
	int callback_code_threaded;
	struct named_value * named_value_table[Named_value_size];

// compact.c
	char *compact_fl;
	unsigned long percent_max;

// debugger.c
	int sock_domain;
	int sock_addr_len;
	int dbg_socket;
	struct channel * dbg_in;
	struct channel * dbg_out;

// extern.c
	byteoffset_t initial_ofs;
	struct extern_obj * extern_table;
	unsigned long extern_table_size;
	byteoffset_t obj_counter_e;
	char * extern_block, * extern_ptr, * extern_limit;
	int extern_block_malloced;
	unsigned long size_32;
	unsigned long size_64;
	int extern_ignore_sharing;
	int extern_closures;

// fail.c
	value exn_bucket;
	struct {
		header_t hdr;
		value exn;
	} out_of_memory_bucket;


// intern.c
	unsigned char * intern_input, * intern_src;
	int intern_input_malloced;
	header_t * intern_dest;
	asize_t obj_counter_i;
	value * intern_obj_table;
	unsigned int intern_color;
	header_t intern_header;
	value intern_block;

// fix_code.c	
	code_t start_code;
	asize_t code_size;
	unsigned char * saved_code;
	unsigned char code_md5[16];
	char ** instr_table;
	char * instr_base;

// freelist.c
	struct {
		value filler1;
		header_t h;
		value first_bp;
		value filler2;
	} sentinel;
	char *fl_prev;
	char *fl_last;
	char *fl_merge;
	asize_t fl_cur_size;
	char *last_fragment;

// gc_ctrl.c
	long stat_minor_words,
     stat_promoted_words,
     stat_major_words,
     stat_minor_collections,
     stat_major_collections,
     stat_heap_size,           /* bytes */
     stat_compactions;

// hash.c
	unsigned long hash_accu;
	long hash_univ_limit, hash_univ_count;

// instrtrace.c
	long icount;
	int trace_flag;

// major_gc.c
	unsigned long percent_free;
	long major_heap_increment;
	char *heap_start, *heap_end;
	page_table_entry *page_table;
	asize_t page_table_size;
	char *gc_sweep_hp;
	int gc_phase;
	value *gray_vals;
	value *gray_vals_cur, *gray_vals_end;
	asize_t gray_vals_size;
	int heap_is_pure;
	unsigned long allocated_words;
	unsigned long extra_heap_memory;
	char *markhp, *chunk, *limit;

// minor_gc.c
	asize_t minor_heap_size;
	char *young_start, *young_end;
	char *young_ptr, *young_limit;
	value **ref_table, **ref_table_end, **ref_table_threshold;
	value **ref_table_ptr, **ref_table_limit;
	asize_t ref_table_size, ref_table_reserve;
	int in_minor_collection;

// misc.h
	unsigned long seed;
	int verb_gc;

// roots.h
	struct caml__roots_block *local_roots;
	struct global_root * global_roots;

// signals.c
	volatile int async_signal_mode;
	volatile int pending_signal;
	volatile int something_to_do;
	volatile int force_major_slice;
	value signal_handlers;

// stack.c
	value * stack_low;
	value * stack_high;
	value * stack_threshold;
	value * extern_sp;
	value * trapsp;
	value * trap_barrier;
	value global_data;
	unsigned long max_stack_size;            /* also used in gc_ctrl.c */

// startup.c
	header_t atom_table[256];
	unsigned long verbose_init;

// str.c
	unsigned char printable_chars_ascii[33];
	unsigned char printable_chars_iso[33];

// sys.c
	char ** main_argv;

// terminfo.c
	struct channel * terminfo_putc_channel;

// weak.c
	value weak_list_head;

// wincmdline.c
	int argc;
	char ** argv;
	int argvsize;

	
};

struct THREADLOCALSTORAGE tls[MAXTHREAD];


//
// Lookup table (threadId, threadHandle) pair
//

PVOID peThread[MAXTHREAD];

extern PVOID  __cdecl getPeThread();
extern int  __cdecl getThreadId(PVOID);
extern int  __cdecl insertThread(PVOID);
extern int  __cdecl removeThread(PVOID);

#endif // _OCAMLDRV_H
