/************************
* Walker Program        *
* CS 672 Final Project  *
*                       *
* Allen Wang            *
* Matt Harren           *
************************/

import java.util.Vector;

import Program.*;
import java.io.Serializable;

public class Vertex implements Serializable
{
	int index;
	double X, Y, vX, vY, angle;
	boolean foot, positiveLastTime;
	
	public Vertex(int index, boolean foot, double X, double Y){
		this.index = index;
		this.foot = foot;
		this.X = X;
		this.Y = Y;
		vX = 0;
		vY = 0;
		positiveLastTime = false;
	}
	
	public void step(double programOutput)
	{
		if (Y <= 0)
		{
			//we're on the ground, don't move in the X direction
			vX = 0;
			Y += vY;
			if((foot)&&(programOutput > 0) )
					vY = 5.0;
		}
		else
		{
			X += vX;
			Y += vY;
		}
		if(!foot)
			angle += programOutput;
		if (Y < 0)
			Y = 0;
	}
	public void checkBoundaries()
	{
		if (Y < 0)
			Y = 0;
	}
	
	public final boolean onGround(){
		return Y <= 0;
	}
	public final int getIndex(){
		return index;
	}
	public final double getX()
	{
		return X;
	}
	public final double getY()
	{
		return Y;
	}
	public final double getVX()
	{
		return vX;
	}
	public final double getVY()
	{
		return vY;
	}
	public final boolean isFoot() {
		return foot;
	}
	
	public final double distanceTo(Vertex other){
		double distX = other.X - X;
		double distY = other.Y - Y;
		return Math.sqrt(distX*distX + distY*distY);
	}
	
	public Vertex copy()
	{
		Vertex v = new Vertex(index, foot, X, Y);
		v.vX = vX;
		v.vY = vY;
		v.positiveLastTime = positiveLastTime;
		return v;
	}
	


}